/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.extension;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.subscription.BackPressureStrategy;
import io.smallrye.mutiny.subscription.MultiEmitter;
import io.smallrye.reactive.messaging.EmitterConfiguration;
import io.smallrye.reactive.messaging.MessagePublisherProvider;
import io.smallrye.reactive.messaging.providers.extension.ThrowingEmitter;
import io.smallrye.reactive.messaging.providers.helpers.BroadcastHelper;
import io.smallrye.reactive.messaging.providers.helpers.NoStackTraceException;
import io.smallrye.reactive.messaging.providers.i18n.ProviderExceptions;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.OnOverflow;

public abstract class AbstractEmitter<T>
implements MessagePublisherProvider<T> {
    public static final NoStackTraceException NO_SUBSCRIBER_EXCEPTION = new NoStackTraceException("Unable to process message - no subscriber");
    protected final AtomicReference<MultiEmitter<? super Message<? extends T>>> internal = new AtomicReference();
    protected final Multi<Message<? extends T>> publisher;
    protected final String name;
    protected final AtomicReference<Throwable> synchronousFailure = new AtomicReference();
    private final OnOverflow.Strategy overflow;
    private final ReentrantLock lock = new ReentrantLock();

    public AbstractEmitter(EmitterConfiguration config, long defaultBufferSize) {
        this.name = config.name();
        this.overflow = config.overflowBufferStrategy();
        if (defaultBufferSize <= 0L) {
            throw ProviderExceptions.ex.illegalArgumentForDefaultBuffer();
        }
        Consumer<MultiEmitter<? super Message<? extends T>>> deferred = fe -> {
            MultiEmitter previous = this.internal.getAndSet((MultiEmitter<Message<T>>)fe);
            if (previous != null) {
                previous.complete();
            }
        };
        Multi<Message<T>> tempPublisher = this.getPublisherForStrategy(config.overflowBufferStrategy(), config.overflowBufferSize(), defaultBufferSize, deferred);
        this.publisher = config.broadcast() ? BroadcastHelper.broadcastPublisher(tempPublisher, config.numberOfSubscriberBeforeConnecting()) : tempPublisher;
    }

    public void complete() {
        this.lock.lock();
        try {
            MultiEmitter<Message<T>> emitter = this.verify();
            if (emitter != null) {
                emitter.complete();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void error(Exception e) {
        if (e == null) {
            throw ProviderExceptions.ex.illegalArgumentForException("null");
        }
        this.lock.lock();
        try {
            MultiEmitter<Message<T>> emitter = this.verify();
            if (emitter != null) {
                emitter.fail((Throwable)e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isCancelled() {
        MultiEmitter<? super Message<? extends T>> emitter = this.internal.get();
        return emitter == null || emitter.isCancelled();
    }

    public boolean hasRequests() {
        MultiEmitter<? super Message<? extends T>> emitter = this.internal.get();
        return !this.isCancelled() && emitter.requested() > 0L;
    }

    Multi<Message<? extends T>> getPublisherForStrategy(OnOverflow.Strategy overFlowStrategy, long bufferSize, long defaultBufferSize, Consumer<MultiEmitter<? super Message<? extends T>>> deferred) {
        if (overFlowStrategy == null) {
            overFlowStrategy = OnOverflow.Strategy.BUFFER;
        }
        switch (overFlowStrategy) {
            case BUFFER: {
                if (bufferSize > 0L) {
                    return ThrowingEmitter.create(deferred, bufferSize);
                }
                return ThrowingEmitter.create(deferred, defaultBufferSize);
            }
            case UNBOUNDED_BUFFER: {
                return Multi.createFrom().emitter(deferred, BackPressureStrategy.BUFFER);
            }
            case THROW_EXCEPTION: {
                return ThrowingEmitter.create(deferred, 0L);
            }
            case DROP: {
                return Multi.createFrom().emitter(deferred, BackPressureStrategy.DROP);
            }
            case FAIL: {
                return Multi.createFrom().emitter(deferred, BackPressureStrategy.ERROR);
            }
            case LATEST: {
                return Multi.createFrom().emitter(deferred, BackPressureStrategy.LATEST);
            }
            case NONE: {
                return Multi.createFrom().emitter(deferred, BackPressureStrategy.IGNORE);
            }
        }
        throw ProviderExceptions.ex.illegalArgumentForBackPressure(overFlowStrategy);
    }

    Multi<Message<? extends T>> getPublisherUsingBufferStrategy(long defaultBufferSize, Multi<Message<? extends T>> stream) {
        int size = (int)defaultBufferSize;
        return stream.onOverflow().buffer(size - 2).onFailure().invoke(this.synchronousFailure::set);
    }

    public Flow.Publisher<Message<? extends T>> getPublisher() {
        return this.publisher;
    }

    protected void emit(Message<? extends T> message) {
        if (message == null) {
            throw ProviderExceptions.ex.illegalArgumentForNullValue();
        }
        this.lock.lock();
        try {
            MultiEmitter<Message<T>> emitter = this.verify();
            if (emitter == null) {
                if (this.overflow == OnOverflow.Strategy.DROP) {
                    message.nack((Throwable)NO_SUBSCRIBER_EXCEPTION);
                }
                return;
            }
            if (this.synchronousFailure.get() != null) {
                throw ProviderExceptions.ex.incomingNotFoundForEmitter(this.synchronousFailure.get());
            }
            if (emitter.isCancelled()) {
                throw ProviderExceptions.ex.illegalStateForDownstreamCancel();
            }
            emitter.emit(message);
            if (this.synchronousFailure.get() != null) {
                throw ProviderExceptions.ex.illegalStateForEmitterWhileEmitting(this.synchronousFailure.get());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected MultiEmitter<? super Message<? extends T>> verify() {
        MultiEmitter<? super Message<? extends T>> emitter = this.internal.get();
        if (emitter == null) {
            if (this.overflow == OnOverflow.Strategy.DROP) {
                return null;
            }
            throw ProviderExceptions.ex.noEmitterForChannel(this.name);
        }
        if (emitter.isCancelled()) {
            throw ProviderExceptions.ex.illegalStateForCancelledSubscriber(this.name);
        }
        return emitter;
    }
}

