/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.impl;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.common.annotation.Identifier;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.ClientCustomizer;
import io.smallrye.reactive.messaging.kafka.KafkaConnectorOutgoingConfiguration;
import io.smallrye.reactive.messaging.kafka.KafkaProducer;
import io.smallrye.reactive.messaging.kafka.SerializationFailureHandler;
import io.smallrye.reactive.messaging.kafka.fault.SerializerWrapper;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaExceptions;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaLogging;
import io.smallrye.reactive.messaging.kafka.impl.ConfigurationCleaner;
import io.smallrye.reactive.messaging.kafka.impl.JsonHelper;
import io.smallrye.reactive.messaging.kafka.impl.KafkaSendingThread;
import io.smallrye.reactive.messaging.providers.helpers.CDIUtils;
import io.smallrye.reactive.messaging.providers.helpers.ConfigUtils;
import io.vertx.core.Context;
import jakarta.enterprise.inject.Instance;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerInterceptor;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.eclipse.microprofile.config.Config;

public class ReactiveKafkaProducer<K, V>
implements KafkaProducer<K, V> {
    private final AtomicBoolean closed = new AtomicBoolean(true);
    private final String clientId;
    private final ProducerInterceptor<K, V> interceptor;
    private final Uni<Producer<K, V>> producerUni;
    private final AtomicReference<Producer<K, V>> producerRef = new AtomicReference();
    private final ExecutorService kafkaWorker;
    private final Map<String, Object> kafkaConfiguration;
    private final String channel;
    private final int closetimeout;
    private Consumer<Throwable> reportFailure;

    public ReactiveKafkaProducer(KafkaConnectorOutgoingConfiguration config, Instance<ClientCustomizer<Map<String, Object>>> configCustomizers, Instance<SerializationFailureHandler<?>> serializationFailureHandlers, Instance<ProducerInterceptor<?, ?>> producerInterceptors, Consumer<Throwable> reportFailure, BiConsumer<Producer<?, ?>, Map<String, Object>> onProducerCreated) {
        this(ReactiveKafkaProducer.getKafkaProducerConfiguration(config, configCustomizers), config.getChannel(), config.getCloseTimeout(), config.getLazyClient(), ReactiveKafkaProducer.getProducerInterceptorBean(config, producerInterceptors), ReactiveKafkaProducer.createSerializationFailureHandler(config.getChannel(), config.getKeySerializationFailureHandler().orElse(null), serializationFailureHandlers), ReactiveKafkaProducer.createSerializationFailureHandler(config.getChannel(), config.getValueSerializationFailureHandler().orElse(null), serializationFailureHandlers), onProducerCreated);
        this.reportFailure = reportFailure;
    }

    public String getClientId() {
        return this.clientId;
    }

    public ReactiveKafkaProducer(Map<String, Object> kafkaConfiguration, String channel, int closeTimeout, boolean lazyClient, ProducerInterceptor<K, V> interceptor, SerializationFailureHandler<K> keySerializationFailureHandler, SerializationFailureHandler<V> valueSerializationFailureHandler, BiConsumer<Producer<?, ?>, Map<String, Object>> onProducerCreated) {
        this.kafkaConfiguration = kafkaConfiguration;
        this.channel = channel;
        this.closetimeout = closeTimeout;
        this.clientId = kafkaConfiguration.get("client.id").toString();
        this.interceptor = interceptor;
        String keySerializerCN = (String)kafkaConfiguration.get("key.serializer");
        String valueSerializerCN = (String)kafkaConfiguration.get("value.serializer");
        if (valueSerializerCN == null) {
            throw KafkaExceptions.ex.missingValueSerializer(this.channel, this.channel);
        }
        SerializerWrapper<K> keySerializer = new SerializerWrapper<K>(keySerializerCN, true, keySerializationFailureHandler);
        SerializerWrapper<V> valueSerializer = new SerializerWrapper<V>(valueSerializerCN, false, valueSerializationFailureHandler);
        keySerializer.configure(kafkaConfiguration, true);
        valueSerializer.configure(kafkaConfiguration, false);
        if (interceptor != null) {
            interceptor.configure(kafkaConfiguration);
        }
        this.kafkaWorker = Executors.newSingleThreadExecutor(KafkaSendingThread::new);
        this.producerUni = Uni.createFrom().item(() -> this.producerRef.updateAndGet(p -> {
            if (p != null) {
                return p;
            }
            org.apache.kafka.clients.producer.KafkaProducer producer = new org.apache.kafka.clients.producer.KafkaProducer(kafkaConfiguration, keySerializer, valueSerializer);
            if (kafkaConfiguration.containsKey("transactional.id")) {
                producer.initTransactions();
            }
            onProducerCreated.accept((Producer<?, ?>)producer, kafkaConfiguration);
            this.closed.set(false);
            return producer;
        })).onFailure().invoke(throwable -> {
            KafkaLogging.log.unableToInitializeProducer(channel, (Throwable)throwable);
            if (this.reportFailure != null) {
                this.reportFailure.accept((Throwable)throwable);
            }
        }).memoize().until(this.closed::get).runSubscriptionOn((Executor)this.kafkaWorker);
        if (!lazyClient) {
            this.producerUni.await().indefinitely();
        }
    }

    private Uni<Producer<K, V>> withProducerOnSendingThread() {
        return this.producerUni;
    }

    @Override
    @CheckReturnValue
    public <T> Uni<T> runOnSendingThread(Function<Producer<K, V>, T> action) {
        return this.withProducerOnSendingThread().map(action);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> runOnSendingThread(Consumer<Producer<K, V>> action) {
        return this.withProducerOnSendingThread().invoke(action).replaceWithVoid();
    }

    @Override
    @CheckReturnValue
    public Uni<RecordMetadata> send(ProducerRecord<K, V> record) {
        return this.withProducerOnSendingThread().chain(c -> {
            ProducerRecord<K, V> intercepted = this.interceptOnSend(record);
            return Uni.createFrom().emitter(em -> c.send(intercepted, (metadata, exception) -> {
                this.interceptOnAcknowledge(intercepted, metadata, exception);
                if (exception != null) {
                    if (record.topic() != null) {
                        KafkaLogging.log.unableToWrite(this.channel, record.topic(), exception);
                    } else {
                        KafkaLogging.log.unableToWrite(this.channel, exception);
                    }
                    em.fail((Throwable)exception);
                } else {
                    em.complete((Object)metadata);
                }
            }));
        });
    }

    @Override
    @CheckReturnValue
    public Uni<Void> flush() {
        return this.runOnSendingThread(Producer::flush);
    }

    @Override
    @CheckReturnValue
    public Uni<List<PartitionInfo>> partitionsFor(String topic) {
        return this.runOnSendingThread((Function)producer -> producer.partitionsFor(topic));
    }

    @Override
    @CheckReturnValue
    public Uni<Void> initTransactions() {
        return this.runOnSendingThread(Producer::initTransactions);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> beginTransaction() {
        return this.runOnSendingThread(Producer::beginTransaction);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> commitTransaction() {
        return this.runOnSendingThread(Producer::commitTransaction);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> abortTransaction() {
        return this.runOnSendingThread(Producer::abortTransaction).onItem().invoke(() -> KafkaLogging.log.transactionAborted(this.clientId, this.channel));
    }

    @Override
    @CheckReturnValue
    public Uni<Void> sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, ConsumerGroupMetadata groupMetadata) {
        return this.runOnSendingThread((Producer<K, V> producer) -> producer.sendOffsetsToTransaction(offsets, groupMetadata));
    }

    private static <K, V> ProducerInterceptor<K, V> getProducerInterceptorBean(KafkaConnectorOutgoingConfiguration config, Instance<ProducerInterceptor<?, ?>> producerInterceptors) {
        return config.getInterceptorBean().flatMap(identifier -> CDIUtils.getInstanceById((Instance)producerInterceptors, (String)identifier).stream().findFirst()).orElse(null);
    }

    private static <T> SerializationFailureHandler<T> createSerializationFailureHandler(String channelName, String failureHandlerName, Instance<SerializationFailureHandler<?>> deserializationFailureHandlers) {
        if (failureHandlerName == null) {
            return null;
        }
        Instance matching = deserializationFailureHandlers.select(new Annotation[]{Identifier.Literal.of((String)failureHandlerName)});
        if (matching.isUnsatisfied()) {
            throw KafkaExceptions.ex.unableToFindSerializationFailureHandler(failureHandlerName, channelName);
        }
        if (matching.stream().count() > 1L) {
            throw KafkaExceptions.ex.unableToFindSerializationFailureHandler(failureHandlerName, channelName, (int)matching.stream().count());
        }
        if (matching.stream().count() == 1L) {
            return (SerializationFailureHandler)matching.get();
        }
        return null;
    }

    private static Map<String, Object> getKafkaProducerConfiguration(KafkaConnectorOutgoingConfiguration configuration, Instance<ClientCustomizer<Map<String, Object>>> configCustomizers) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        JsonHelper.asJsonObject(configuration.config()).forEach(e -> map.put((String)e.getKey(), e.getValue().toString()));
        map.put("acks", configuration.getAcks());
        if (!map.containsKey("bootstrap.servers")) {
            KafkaLogging.log.configServers("bootstrap.servers", configuration.getBootstrapServers());
            map.put("bootstrap.servers", configuration.getBootstrapServers());
        }
        if (!map.containsKey("key.serializer")) {
            KafkaLogging.log.keySerializerOmitted();
            map.put("key.serializer", configuration.getKeySerializer());
        }
        map.compute("client.id", (k, configured) -> {
            if (configured == null) {
                return configuration.getClientIdPrefix().orElse("kafka-producer-") + configuration.getChannel();
            }
            return configuration.getClientIdPrefix().orElse("") + configured;
        });
        if (!map.containsKey("reconnect.backoff.max.ms")) {
            map.put("reconnect.backoff.max.ms", "10000");
        }
        ConfigurationCleaner.cleanupProducerConfiguration(map);
        return (Map)ConfigUtils.customize((Config)configuration.config(), configCustomizers, map);
    }

    public String get(String attribute) {
        return (String)this.kafkaConfiguration.get(attribute);
    }

    @Override
    public Producer<K, V> unwrap() {
        return this.producerRef.get();
    }

    @Override
    public Map<String, ?> configuration() {
        return this.kafkaConfiguration;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            int timeout = this.closetimeout;
            Uni uni = this.runOnSendingThread((Producer<K, V> p) -> {
                this.interceptClose();
                if (System.getSecurityManager() == null) {
                    p.close(Duration.ofMillis(timeout));
                } else {
                    AccessController.doPrivileged(() -> {
                        p.close(Duration.ofMillis(timeout));
                        return null;
                    });
                }
            }).onItem().invoke(this.kafkaWorker::shutdown);
            if (Context.isOnEventLoopThread()) {
                uni.subscribeAsCompletionStage();
            } else {
                uni.await().atMost(Duration.ofMillis((long)timeout * 2L));
            }
        }
    }

    private ProducerRecord<K, V> interceptOnSend(ProducerRecord<K, V> record) {
        if (this.interceptor != null) {
            try {
                return this.interceptor.onSend(record);
            }
            catch (Throwable t) {
                KafkaLogging.log.interceptorOnSendError(this.channel, t);
            }
        }
        return record;
    }

    private void interceptOnAcknowledge(ProducerRecord<K, V> intercepted, RecordMetadata recordMetadata, Exception exception) {
        if (this.interceptor != null) {
            try {
                RecordMetadata metadata = exception == null ? recordMetadata : ReactiveKafkaProducer.getRecordMetadataForFailure(intercepted);
                this.interceptor.onAcknowledgement(metadata, exception);
            }
            catch (Throwable t) {
                KafkaLogging.log.interceptorOnAcknowledgeError(this.channel, t);
            }
        }
    }

    private static RecordMetadata getRecordMetadataForFailure(ProducerRecord<?, ?> producerRecord) {
        return new RecordMetadata(new TopicPartition(producerRecord.topic(), producerRecord.partition() != null ? producerRecord.partition() : -1), -1L, -1, -1L, -1, -1);
    }

    private void interceptClose() {
        if (this.interceptor != null) {
            try {
                this.interceptor.close();
            }
            catch (Throwable t) {
                KafkaLogging.log.interceptorCloseError(this.channel, t);
            }
        }
    }
}

