/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Incubating;
import org.hibernate.Internal;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.mapping.AbstractUserDefinedType;
import org.hibernate.mapping.Column;

@Incubating
public class UserDefinedObjectType
extends AbstractUserDefinedType {
    private final Map<String, Column> columns = new LinkedHashMap<String, Column>();
    private int[] orderMapping;
    private String comment;

    public UserDefinedObjectType(String contributor, Namespace namespace, Identifier physicalTypeName) {
        super(contributor, namespace, physicalTypeName);
    }

    public Column getColumn(Column column) {
        if (column == null) {
            return null;
        }
        Column existing = this.columns.get(column.getCanonicalName());
        return column.equals(existing) ? existing : null;
    }

    public Column getColumn(Identifier name) {
        if (name == null) {
            return null;
        }
        return this.columns.get(name.getCanonicalName());
    }

    public Column getColumn(int n) {
        Iterator<Column> iter = this.columns.values().iterator();
        for (int i = 0; i < n - 1; ++i) {
            iter.next();
        }
        return iter.next();
    }

    public void addColumn(Column column) {
        Column old = this.getColumn(column);
        if (old == null) {
            this.columns.put(column.getCanonicalName(), column);
            column.uniqueInteger = this.columns.size();
        } else {
            column.uniqueInteger = old.uniqueInteger;
        }
    }

    public int getColumnSpan() {
        return this.columns.size();
    }

    public Collection<Column> getColumns() {
        return this.columns.values();
    }

    public boolean containsColumn(Column column) {
        return this.columns.containsValue(column);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Internal
    public void reorderColumns(List<Column> columns) {
        if (this.orderMapping != null) {
            return;
        }
        this.orderMapping = new int[columns.size()];
        int i = 0;
        for (Column column : this.columns.values()) {
            this.orderMapping[columns.indexOf((Object)column)] = i++;
        }
        this.columns.clear();
        for (Column column : columns) {
            this.columns.put(column.getCanonicalName(), column);
        }
    }

    @Internal
    public int[] getOrderMapping() {
        return this.orderMapping;
    }
}

