/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web.session.hotrod;

import jakarta.servlet.ServletContext;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.DefaultTemplate;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.configuration.RemoteCacheConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.near.NearCacheFactory;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheConfiguration;
import org.wildfly.clustering.infinispan.client.service.HotRodServiceDescriptor;
import org.wildfly.clustering.infinispan.client.service.RemoteCacheConfigurationServiceInstallerFactory;
import org.wildfly.clustering.infinispan.client.service.RemoteCacheServiceInstallerFactory;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.session.SessionManagerFactory;
import org.wildfly.clustering.session.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.session.infinispan.remote.HotRodSessionManagerFactory;
import org.wildfly.clustering.session.infinispan.remote.SessionManagerNearCacheFactory;
import org.wildfly.clustering.session.spec.SessionEventListenerSpecificationProvider;
import org.wildfly.clustering.session.spec.SessionSpecificationProvider;
import org.wildfly.clustering.session.spec.servlet.HttpSessionActivationListenerProvider;
import org.wildfly.clustering.session.spec.servlet.HttpSessionProvider;
import org.wildfly.clustering.web.service.WebDeploymentServiceDescriptor;
import org.wildfly.clustering.web.service.routing.RouteLocatorProvider;
import org.wildfly.clustering.web.service.session.DistributableSessionManagementConfiguration;
import org.wildfly.common.function.Functions;
import org.wildfly.extension.clustering.web.session.AbstractSessionManagementProvider;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.DeploymentServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class HotRodSessionManagementProvider
extends AbstractSessionManagementProvider {
    public HotRodSessionManagementProvider(DistributableSessionManagementConfiguration<DeploymentUnit> configuration, BinaryServiceConfiguration cacheConfiguration, Supplier<RouteLocatorProvider> locatorProviderFactory) {
        super(configuration, cacheConfiguration, locatorProviderFactory);
    }

    public <C> DeploymentServiceInstaller getSessionManagerFactoryServiceInstaller(final SessionManagerFactoryConfiguration<C> configuration) {
        final OptionalInt maxActiveSessions = configuration.getMaxActiveSessions();
        final NearCacheMode mode = maxActiveSessions.isPresent() ? NearCacheMode.INVALIDATED : NearCacheMode.DISABLED;
        BinaryServiceConfiguration deploymentCacheConfiguration = this.getCacheConfiguration().withChildName(configuration.getDeploymentName());
        final String templateName = Optional.ofNullable(this.getCacheConfiguration().getChildName()).orElse(DefaultTemplate.DIST_SYNC.getTemplateName());
        Consumer<RemoteCacheConfigurationBuilder> configurator = new Consumer<RemoteCacheConfigurationBuilder>(){

            @Override
            public void accept(RemoteCacheConfigurationBuilder builder) {
                builder.forceReturnValues(false).nearCacheMode(mode).templateName(templateName).transactionMode(TransactionMode.NONE);
                if (mode.invalidated()) {
                    builder.nearCacheFactory((NearCacheFactory)new SessionManagerNearCacheFactory(maxActiveSessions));
                }
            }
        };
        ServiceInstaller configurationInstaller = new RemoteCacheConfigurationServiceInstallerFactory((Consumer)configurator).apply(deploymentCacheConfiguration);
        ServiceInstaller cacheInstaller = RemoteCacheServiceInstallerFactory.INSTANCE.apply(deploymentCacheConfiguration);
        final ServiceDependency cache = deploymentCacheConfiguration.getServiceDependency(HotRodServiceDescriptor.REMOTE_CACHE);
        final RemoteCacheConfiguration cacheConfiguration = new RemoteCacheConfiguration(){

            public <CK, CV> RemoteCache<CK, CV> getCache() {
                return (RemoteCache)cache.get();
            }
        };
        Supplier factory = new Supplier<SessionManagerFactory<ServletContext, C>>(){

            @Override
            public SessionManagerFactory<ServletContext, C> get() {
                return new HotRodSessionManagerFactory(configuration, (SessionSpecificationProvider)HttpSessionProvider.INSTANCE, (SessionEventListenerSpecificationProvider)HttpSessionActivationListenerProvider.INSTANCE, cacheConfiguration);
            }
        };
        DeploymentServiceInstaller installer = (DeploymentServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Supplier)factory).provides(ServiceNameFactory.resolveServiceName((UnaryServiceDescriptor)WebDeploymentServiceDescriptor.SESSION_MANAGER_FACTORY, (String)configuration.getDeploymentName()))).requires((Consumer)cache)).onStop(Functions.closingConsumer())).build();
        return DeploymentServiceInstaller.combine((DeploymentServiceInstaller[])new DeploymentServiceInstaller[]{configurationInstaller, cacheInstaller, installer});
    }
}

