/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;

final class Reflect {
    Reflect() {
    }

    static Field findField(final Class<?> sourceClass, final Class<?> fieldType) {
        return AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                Class<?> type;
                Field[] fields;
                LinkedList<Field> assignableFields = new LinkedList<Field>();
                for (Field field : fields = sourceClass.getDeclaredFields()) {
                    type = field.getType();
                    if (Modifier.isStatic(field.getModifiers()) || type != fieldType) continue;
                    assignableFields.add(field);
                }
                if (assignableFields.isEmpty()) {
                    for (Field field : fields) {
                        type = field.getType();
                        if (Modifier.isStatic(field.getModifiers()) || type == Object.class || !type.isAssignableFrom(fieldType)) continue;
                        assignableFields.add(field);
                    }
                }
                if (assignableFields.size() > 1) {
                    throw new IllegalStateException(((Object)assignableFields).toString());
                }
                if (!assignableFields.isEmpty()) {
                    Field field = (Field)assignableFields.get(0);
                    field.setAccessible(true);
                    return field;
                }
                Class superClass = sourceClass.getSuperclass();
                if (superClass == null || superClass == Object.class) {
                    throw new IllegalArgumentException(fieldType.getName());
                }
                return Reflect.findField(superClass, fieldType);
            }
        });
    }

    static Method findMethod(final Class<?> sourceClass, final Class<?> returnType) {
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                LinkedList<Method> matchingMethods = new LinkedList<Method>();
                for (Method method : sourceClass.getDeclaredMethods()) {
                    if (Modifier.isStatic(method.getModifiers()) || method.getParameterCount() != 0 || method.getReturnType() != returnType) continue;
                    matchingMethods.add(method);
                }
                if (matchingMethods.size() > 1) {
                    throw new IllegalStateException(((Object)matchingMethods).toString());
                }
                if (!matchingMethods.isEmpty()) {
                    Method method = (Method)matchingMethods.get(0);
                    method.setAccessible(true);
                    return method;
                }
                Class superClass = sourceClass.getSuperclass();
                if (superClass == null || superClass == Object.class) {
                    throw new IllegalArgumentException(returnType.getName());
                }
                return Reflect.findMethod(superClass, returnType);
            }
        });
    }

    static Method findMethod(final Class<?> sourceClass, final String methodName) {
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    Method method = sourceClass.getDeclaredMethod(methodName, new Class[0]);
                    method.setAccessible(true);
                    return method;
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    static <T> Constructor<T> getConstructor(final Class<T> sourceClass, final Class<?> ... parameterTypes) {
        return (Constructor)AccessController.doPrivileged(new PrivilegedAction<Constructor<T>>(){

            @Override
            public Constructor<T> run() {
                try {
                    Constructor constructor = sourceClass.getDeclaredConstructor(parameterTypes);
                    constructor.setAccessible(true);
                    return constructor;
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    static <T> T newInstance(final Constructor<T> constructor, final Object ... parameters) {
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                try {
                    return constructor.newInstance(parameters);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    static Object getValue(Object source, Field field) {
        return Reflect.getValue(source, field, Object.class);
    }

    static <T> T getValue(final Object source, final Field field, final Class<T> fieldType) {
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                try {
                    return fieldType.cast(field.get(source));
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    static void setValue(final Object source, final Field field, final Object value) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    field.set(source, value);
                    return null;
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    static Object invoke(Object source, Method method) {
        return Reflect.invoke(source, method, Object.class);
    }

    static <T> T invoke(final Object source, final Method method, final Class<T> returnClass) {
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                try {
                    return returnClass.cast(method.invoke(source, new Object[0]));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }
}

