/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.api;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.jboss.jca.core.connectionmanager.pool.PoolStatisticsImpl;

public class Semaphore
extends java.util.concurrent.Semaphore {
    private static final long serialVersionUID = 4L;
    private int maxSize;
    private PoolStatisticsImpl statistics;
    private static final int CURRENT_THREAD = 1;

    public Semaphore(int maxSize, boolean fairness, PoolStatisticsImpl statistics) {
        super(maxSize, fairness);
        this.maxSize = maxSize;
        this.statistics = statistics;
    }

    @Override
    public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
        boolean result;
        if (this.statistics.isEnabled()) {
            if (this.availablePermits() == 0) {
                this.statistics.setMaxWaitCount(this.getQueueLength() + 1);
            } else {
                this.statistics.setMaxWaitCount(this.getQueueLength());
            }
        }
        if ((result = super.tryAcquire(timeout, unit)) && this.statistics.isEnabled()) {
            this.statistics.setInUsedCount(this.maxSize - this.availablePermits());
        }
        return result;
    }

    @Override
    public void release() {
        super.release();
        if (this.statistics.isEnabled()) {
            this.statistics.setInUsedCount(this.maxSize - this.availablePermits());
        }
    }

    @Override
    public Collection<Thread> getQueuedThreads() {
        return super.getQueuedThreads();
    }
}

