/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.reactive.messaging;

import java.util.Collection;
import java.util.Collections;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.RuntimePackageDependency;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.extension.microprofile.reactive.messaging.MicroProfileReactiveMessagingExtension;
import org.wildfly.extension.microprofile.reactive.messaging._private.MicroProfileReactiveMessagingLogger;
import org.wildfly.extension.microprofile.reactive.messaging.deployment.ReactiveMessagingDependencyProcessor;
import org.wildfly.microprofile.reactive.messaging.common.security.ElytronSSLContextRegistry;
import org.wildfly.security.manager.WildFlySecurityManager;

public class MicroProfileReactiveMessagingSubsystemDefinition
extends PersistentResourceDefinition {
    private static final String REACTIVE_MESSAGING_CAPABILITY_NAME = "org.wildfly.microprofile.reactive-messaging";
    private static final RuntimeCapability<Void> REACTIVE_STREAMS_OPERATORS_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.microprofile.reactive-messaging").addRequirements(new String[]{"org.wildfly.weld"}).addRequirements(new String[]{"org.wildfly.microprofile.reactive-streams-operators"}).build();

    public MicroProfileReactiveMessagingSubsystemDefinition() {
        super(new SimpleResourceDefinition.Parameters(MicroProfileReactiveMessagingExtension.SUBSYSTEM_PATH, (ResourceDescriptionResolver)MicroProfileReactiveMessagingExtension.SUBSYSTEM_RESOLVER).setAddHandler((OperationStepHandler)new AddHandler()).setRemoveHandler((OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE).setCapabilities(new RuntimeCapability[]{REACTIVE_STREAMS_OPERATORS_CAPABILITY}));
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Collections.emptyList();
    }

    public void registerAdditionalRuntimePackages(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerAdditionalRuntimePackages(new RuntimePackageDependency[]{RuntimePackageDependency.required((String)"io.reactivex.rxjava2.rxjava"), RuntimePackageDependency.required((String)"io.smallrye.reactive.messaging"), RuntimePackageDependency.required((String)"io.smallrye.reactive.messaging.connector"), RuntimePackageDependency.required((String)"io.vertx.client"), RuntimePackageDependency.required((String)"org.apache.commons.lang3"), RuntimePackageDependency.required((String)"org.eclipse.microprofile.reactive-messaging.api"), RuntimePackageDependency.required((String)"org.wildfly.reactive.messaging.config"), RuntimePackageDependency.required((String)"org.slf4j")});
    }

    static class AddHandler
    extends AbstractBoottimeAddStepHandler {
        AddHandler() {
        }

        protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.performBoottime(context, operation, model);
            this.installElytronSSLContextRegistryServiceIfPresent(context);
            context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

                public void execute(DeploymentProcessorTarget processorTarget) {
                    processorTarget.addDeploymentProcessor("microprofile-reactive-messaging-smallrye", Phase.DEPENDENCIES, 6320, (DeploymentUnitProcessor)new ReactiveMessagingDependencyProcessor());
                }
            }, OperationContext.Stage.RUNTIME);
            MicroProfileReactiveMessagingLogger.LOGGER.activatingSubsystem();
        }

        private void installElytronSSLContextRegistryServiceIfPresent(OperationContext context) {
            ClassLoader cl = WildFlySecurityManager.getClassLoaderPrivileged(((Object)((Object)this)).getClass());
            if (cl instanceof ModuleClassLoader) {
                ModuleLoader loader = ((ModuleClassLoader)cl).getModule().getModuleLoader();
                try {
                    loader.loadModule("org.wildfly.reactive.messaging.common");
                    ElytronSSLContextRegistry.setServiceRegistry((ServiceRegistry)context.getServiceRegistry(false));
                }
                catch (ModuleLoadException moduleLoadException) {
                    // empty catch block
                }
            }
        }
    }
}

