/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.audit;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.audit.AuditLogHandler;
import org.jboss.as.controller.audit.InMemoryAuditLogHandler;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.audit.AuditLogHandlerResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class InMemoryAuditLogHandlerResourceDefinition
extends AuditLogHandlerResourceDefinition {
    public static final SimpleAttributeDefinition MAX_OPERATION_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-history", (ModelType)ModelType.INT).setRequired(false)).setAllowExpression(true)).setDefaultValue(new ModelNode(10))).setValidator((ParameterValidator)new IntRangeValidator(0, true, true))).build();
    public static final AttributeDefinition HISTORY_ELEMENT = new ObjectTypeAttributeDefinition.Builder("operation", new AttributeDefinition[]{((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"operation-date", (ModelType)ModelType.STRING, (boolean)false).setStorageRuntime()).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"version", (ModelType)ModelType.STRING, (boolean)false).setStorageRuntime()).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"user", (ModelType)ModelType.STRING, (boolean)false).setStorageRuntime()).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"domain-uuid", (ModelType)ModelType.STRING, (boolean)false).setStorageRuntime()).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"access-mechanism", (ModelType)ModelType.STRING, (boolean)false).setStorageRuntime()).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"remote-address", (ModelType)ModelType.STRING, (boolean)false).setStorageRuntime()).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"outcome", (ModelType)ModelType.STRING, (boolean)false).setStorageRuntime()).build(), SimpleListAttributeDefinition.Builder.of((String)"operations", (AttributeDefinition)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"operation", (ModelType)ModelType.STRING, (boolean)false).setStorageRuntime()).build()).build()}).build();
    public static final String OPERATION_NAME = "show-logs";
    protected static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{MAX_OPERATION_COUNT};

    public InMemoryAuditLogHandlerResourceDefinition(ManagedAuditLogger auditLogger) {
        super(auditLogger, null, PathElement.pathElement((String)"in-memory-handler"), DomainManagementResolver.getResolver("core.management.in-memory-handler"), (OperationStepHandler)new InMemoryAuditLogHandlerAddHandler(auditLogger), (OperationStepHandler)new AuditLogHandlerResourceDefinition.HandlerRemoveHandler(auditLogger));
    }

    @Override
    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder(OPERATION_NAME, this.getResourceDescriptionResolver()).setReadOnly().setRuntimeOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).build(), (OperationStepHandler)new ShowInMemoryLogsHandler(this.auditLogger));
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition def : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(def, null, (OperationStepHandler)new InMemoryMaxHistoryWriteHandler(this.auditLogger));
        }
    }

    public static ModelNode createServerAddOperation(PathAddress address, ModelNode fileHandler) {
        ModelNode add = Util.createAddOperation((PathAddress)address);
        for (AttributeDefinition def : ATTRIBUTES) {
            if (!fileHandler.get(def.getName()).isDefined()) continue;
            add.get(def.getName()).set(fileHandler.get(def.getName()));
        }
        return add;
    }

    protected static class InMemoryMaxHistoryWriteHandler
    extends AbstractWriteAttributeHandler<Void> {
        private final ManagedAuditLogger auditLogger;

        public InMemoryMaxHistoryWriteHandler(ManagedAuditLogger auditLogger) {
            this.auditLogger = auditLogger;
        }

        protected boolean requiresRuntime(OperationContext context) {
            return true;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
            if ("max-history".equals(attributeName)) {
                String name = Util.getNameFromAddress((ModelNode)operation.require("address"));
                this.auditLogger.updateInMemoryHandlerMaxHistory(name, valueToRevert.asInt());
            }
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
            if ("max-history".equals(attributeName)) {
                String name = Util.getNameFromAddress((ModelNode)operation.require("address"));
                this.auditLogger.updateInMemoryHandlerMaxHistory(name, resolvedValue.asInt());
            }
            return false;
        }
    }

    protected static class InMemoryAuditLogHandlerAddHandler
    extends AbstractAddStepHandler {
        private final ManagedAuditLogger auditLogger;

        private InMemoryAuditLogHandlerAddHandler(ManagedAuditLogger auditLogger) {
            this.auditLogger = auditLogger;
        }

        protected boolean requiresRuntime(OperationContext context) {
            return true;
        }

        private InMemoryAuditLogHandler createHandler(OperationContext context, ModelNode model) throws OperationFailedException {
            String name = context.getCurrentAddressValue();
            int maxHistory = MAX_OPERATION_COUNT.resolveModelAttribute(context, model).asInt();
            return new InMemoryAuditLogHandler(name, maxHistory);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            InMemoryAuditLogHandler handler = this.createHandler(context, model);
            this.auditLogger.getUpdater().addHandler((AuditLogHandler)handler);
            this.auditLogger.addFormatter(handler.getFormatter());
        }

        protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
            this.auditLogger.getUpdater().rollbackChanges();
        }
    }

    protected static class ShowInMemoryLogsHandler
    extends AbstractRuntimeOnlyHandler {
        private final ManagedAuditLogger auditLogger;

        ShowInMemoryLogsHandler(ManagedAuditLogger auditLogger) {
            this.auditLogger = auditLogger;
        }

        protected boolean requiresRuntime(OperationContext context) {
            return true;
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            String name = Util.getNameFromAddress((ModelNode)operation.require("address"));
            ModelNode result = context.getResult().setEmptyList();
            List items = this.auditLogger.listLastEntries(name);
            for (int i = items.size() - 1; i >= 0; --i) {
                ModelNode entry = (ModelNode)items.get(i);
                ModelNode configurationChange = entry.clone();
                result.add(configurationChange);
            }
        }
    }
}

