CREATE TABLE IF NOT EXISTS JOB_INSTANCE (
  JOBINSTANCEID   BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  VERSION         INTEGER,
  JOBNAME         VARCHAR(512),
  APPLICATIONNAME VARCHAR(512)
)!!
CREATE TABLE IF NOT EXISTS JOB_EXECUTION (
  JOBEXECUTIONID  BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  JOBINSTANCEID   BIGINT             NOT NULL,
  VERSION         INTEGER,
  CREATETIME      DATETIME,
  STARTTIME       DATETIME,
  ENDTIME         DATETIME,
  LASTUPDATEDTIME DATETIME,
  BATCHSTATUS     VARCHAR(30),
  EXITSTATUS      VARCHAR(512),
  JOBPARAMETERS   VARCHAR(3000),
  RESTARTPOSITION VARCHAR(255),
  CONSTRAINT FK_JOB_EXECUTION_JOB_INSTANCE FOREIGN KEY (JOBINSTANCEID) REFERENCES JOB_INSTANCE (JOBINSTANCEID) ON DELETE CASCADE
)!!
CREATE TABLE IF NOT EXISTS STEP_EXECUTION (
  STEPEXECUTIONID    BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  JOBEXECUTIONID     BIGINT             NOT NULL,
  VERSION            INTEGER,
  STEPNAME           VARCHAR(255),
  STARTTIME          DATETIME,
  ENDTIME            DATETIME,
  BATCHSTATUS        VARCHAR(30),
  EXITSTATUS         VARCHAR(512),
  EXECUTIONEXCEPTION VARCHAR(2048),
  PERSISTENTUSERDATA BLOB,
  READCOUNT          INTEGER,
  WRITECOUNT         INTEGER,
  COMMITCOUNT        INTEGER,
  ROLLBACKCOUNT      INTEGER,
  READSKIPCOUNT      INTEGER,
  PROCESSSKIPCOUNT   INTEGER,
  FILTERCOUNT        INTEGER,
  WRITESKIPCOUNT     INTEGER,
  READERCHECKPOINTINFO  BLOB,
  WRITERCHECKPOINTINFO  BLOB,
  CONSTRAINT FK_STEP_EXE_JOB_EXE FOREIGN KEY (JOBEXECUTIONID) REFERENCES JOB_EXECUTION (JOBEXECUTIONID) ON DELETE CASCADE
)!!
CREATE TABLE IF NOT EXISTS PARTITION_EXECUTION (
  PARTITIONEXECUTIONID  INTEGER NOT NULL,
  STEPEXECUTIONID       BIGINT  NOT NULL,
  VERSION               INTEGER,
  BATCHSTATUS           VARCHAR(30),
  EXITSTATUS            VARCHAR(512),
  EXECUTIONEXCEPTION    VARCHAR(2048),
  PERSISTENTUSERDATA    BLOB,
  READERCHECKPOINTINFO  BLOB,
  WRITERCHECKPOINTINFO  BLOB,
  PRIMARY KEY (PARTITIONEXECUTIONID, STEPEXECUTIONID),
  CONSTRAINT FK_PARTITION_EXE_STEP_EXE FOREIGN KEY (STEPEXECUTIONID) REFERENCES STEP_EXECUTION (STEPEXECUTIONID) ON DELETE CASCADE
)!!

