/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web;

import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.clustering.infinispan.client.service.HotRodServiceDescriptor;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.web.service.routing.RouteLocatorProvider;
import org.wildfly.extension.clustering.web.LocalAffinityResourceDefinition;
import org.wildfly.extension.clustering.web.SessionManagementResourceDefinition;
import org.wildfly.extension.clustering.web.session.hotrod.HotRodSessionManagementProvider;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ResourceModelResolver;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class HotRodSessionManagementResourceDefinition
extends SessionManagementResourceDefinition {
    static final PathElement WILDCARD_PATH = HotRodSessionManagementResourceDefinition.pathElement("*");
    private final ResourceModelResolver<BinaryServiceConfiguration> resolver = BinaryServiceConfiguration.resolver((AttributeDefinition)Attribute.REMOTE_CACHE_CONTAINER.getDefinition(), (AttributeDefinition)Attribute.CACHE_CONFIGURATION.getDefinition());

    static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"hotrod-session-management", (String)name);
    }

    HotRodSessionManagementResourceDefinition() {
        super(WILDCARD_PATH, new UnaryOperator<ResourceDescriptor>(){

            @Override
            public ResourceDescriptor apply(ResourceDescriptor descriptor) {
                return descriptor.addAttributes(Attribute.class).addRequiredSingletonChildren(new PathElement[]{LocalAffinityResourceDefinition.PATH});
            }
        });
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        ServiceDependency locatorProvider = ServiceDependency.on((UnaryServiceDescriptor)RouteLocatorProvider.SERVICE_DESCRIPTOR, (String)context.getCurrentAddressValue());
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(SessionManagementResourceDefinition.SESSION_MANAGEMENT_PROVIDER, (Object)new HotRodSessionManagementProvider(this.resolve(context, model), (BinaryServiceConfiguration)this.resolver.resolve(context, model), (Supplier<RouteLocatorProvider>)locatorProvider)).requires((Consumer)locatorProvider)).build();
    }

    public static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        REMOTE_CACHE_CONTAINER("remote-cache-container", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setAllowExpression(false)).setRequired(true)).setCapabilityReference((org.jboss.as.controller.CapabilityReferenceRecorder)CapabilityReferenceRecorder.builder(SessionManagementResourceDefinition.SESSION_MANAGEMENT_PROVIDER, (UnaryServiceDescriptor)HotRodServiceDescriptor.REMOTE_CACHE_CONTAINER).build());
            }
        }
        ,
        CACHE_CONFIGURATION("cache-configuration", ModelType.STRING),
        EXPIRATION_THREAD_POOL_SIZE("expiration-thread-pool-size", ModelType.INT){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setDefaultValue(new ModelNode(16));
            }
        };

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type) {
            this.definition = this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
            return builder;
        }
    }
}

