/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.jaspi.impl;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.config.ServerAuthContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.jaspi.impl.ThreadLocalCallbackHandler;

public class WrappingServerAuthContext
implements ServerAuthContext {
    private final ThreadLocalCallbackHandler threadLocalHandler;
    private final CallbackHandler realHandler;
    private final ServerAuthContext delegate;

    WrappingServerAuthContext(ThreadLocalCallbackHandler threadLocalHandler, CallbackHandler realHandler, ServerAuthContext delegate) {
        this.threadLocalHandler = (ThreadLocalCallbackHandler)Assert.checkNotNullParam((String)"threadLocalHandler", (Object)threadLocalHandler);
        this.realHandler = (CallbackHandler)Assert.checkNotNullParam((String)"realHandler", (Object)realHandler);
        this.delegate = (ServerAuthContext)Assert.checkNotNullParam((String)"delegate", (Object)delegate);
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        return (AuthStatus)this.threadLocalHandler.get(() -> this.delegate.validateRequest(messageInfo, clientSubject, serviceSubject), this.realHandler);
    }

    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        return (AuthStatus)this.threadLocalHandler.get(() -> this.delegate.secureResponse(messageInfo, serviceSubject), this.realHandler);
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        this.threadLocalHandler.get(() -> {
            this.delegate.cleanSubject(messageInfo, subject);
            return null;
        }, this.realHandler);
    }
}

