/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.mirror;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import org.apache.activemq.artemis.api.core.ActiveMQAddressDoesNotExistException;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.DuplicateIDCache;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.server.mirror.MirrorController;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperation;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessageBrokerAccessor;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerSource;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AckManager;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AckManagerProvider;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.BasicMirrorController;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.MirrorTransaction;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.ReferenceIDSupplier;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPTunneledCoreLargeMessageReader;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPTunneledCoreMessageReader;
import org.apache.activemq.artemis.protocol.amqp.proton.MessageReader;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonAbstractReceiver;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.pools.MpscPool;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPMirrorControllerTarget
extends ProtonAbstractReceiver
implements MirrorController {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final ThreadLocal<MirrorController> CONTROLLER_THREAD_LOCAL = new ThreadLocal();
    private final MpscPool<ACKMessageOperation> ackMessageMpscPool;
    final RoutingContextImpl routingContext;
    final BasicMirrorController<Receiver> basicController;
    final ActiveMQServer server;
    final Configuration configuration;
    DuplicateIDCache lruduplicateIDCache;
    String lruDuplicateIDKey;
    private final ReferenceIDSupplier referenceNodeStore;
    OperationContext mirrorContext;
    private MessageReader coreMessageReader;
    private MessageReader coreLargeMessageReader;
    private AckManager ackManager;

    public static void setControllerInUse(MirrorController controller) {
        CONTROLLER_THREAD_LOCAL.set(controller);
    }

    public static MirrorController getControllerInUse() {
        return CONTROLLER_THREAD_LOCAL.get();
    }

    public AMQPMirrorControllerTarget(AMQPSessionCallback sessionSPI, AMQPConnectionContext connection, AMQPSessionContext protonSession, Receiver receiver, ActiveMQServer server) {
        super(sessionSPI, connection, protonSession, receiver);
        this.ackMessageMpscPool = new MpscPool(this.connection.getAmqpCredits(), ACKMessageOperation::reset, () -> new ACKMessageOperation());
        this.routingContext = new RoutingContextImpl(null);
        this.basicController = new BasicMirrorController(server);
        this.basicController.setLink(receiver);
        this.server = server;
        this.configuration = server.getConfiguration();
        this.referenceNodeStore = sessionSPI.getProtocolManager().getReferenceIDSupplier();
        this.mirrorContext = protonSession.getSessionSPI().getSessionContext();
    }

    public String getRemoteMirrorId() {
        return this.basicController.getRemoteMirrorId();
    }

    @Override
    public void flow() {
        this.creditRunnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actualDelivery(Message message, Delivery delivery, DeliveryAnnotations deliveryAnnotations, Receiver receiver, Transaction tx) {
        this.recoverContext();
        this.incrementSettle();
        logger.trace("{}::actualdelivery call for {}", (Object)this.server, (Object)message);
        AMQPMirrorControllerTarget.setControllerInUse(this);
        delivery.setContext((Object)message);
        ACKMessageOperation messageAckOperation = ((ACKMessageOperation)this.ackMessageMpscPool.borrow()).setDelivery(delivery);
        try {
            if (message instanceof AMQPMessage) {
                AMQPMessage amqpMessage = (AMQPMessage)message;
                Object eventType = AMQPMessageBrokerAccessor.getMessageAnnotationProperty(amqpMessage, AMQPMirrorControllerSource.EVENT_TYPE);
                if (eventType != null) {
                    if (eventType.equals(AMQPMirrorControllerSource.ADD_ADDRESS)) {
                        AddressInfo addressInfo = this.parseAddress(amqpMessage);
                        this.addAddress(addressInfo);
                    } else if (eventType.equals(AMQPMirrorControllerSource.DELETE_ADDRESS)) {
                        AddressInfo addressInfo = this.parseAddress(amqpMessage);
                        this.deleteAddress(addressInfo);
                    } else if (eventType.equals(AMQPMirrorControllerSource.CREATE_QUEUE)) {
                        QueueConfiguration queueConfiguration = this.parseQueue(amqpMessage);
                        this.createQueue(queueConfiguration);
                    } else if (eventType.equals(AMQPMirrorControllerSource.DELETE_QUEUE)) {
                        String address = (String)AMQPMessageBrokerAccessor.getMessageAnnotationProperty(amqpMessage, AMQPMirrorControllerSource.ADDRESS);
                        String queueName = (String)AMQPMessageBrokerAccessor.getMessageAnnotationProperty(amqpMessage, AMQPMirrorControllerSource.QUEUE);
                        this.deleteQueue(SimpleString.of((String)address), SimpleString.of((String)queueName));
                    } else if (eventType.equals(AMQPMirrorControllerSource.POST_ACK)) {
                        AmqpValue value;
                        Long messageID;
                        String queueName;
                        String nodeID = (String)AMQPMessageBrokerAccessor.getMessageAnnotationProperty(amqpMessage, AMQPMirrorControllerSource.BROKER_ID);
                        logger.trace("ACK towards NodeID = {}, while the localNodeID={}", (Object)nodeID, (Object)this.server.getNodeID());
                        AckReason ackReason = AMQPMessageBrokerAccessor.getMessageAnnotationAckReason(amqpMessage);
                        if (nodeID == null) {
                            nodeID = this.getRemoteMirrorId();
                            logger.trace("Replacing nodeID by {}", (Object)nodeID);
                        }
                        if (this.postAcknowledge(queueName = (String)AMQPMessageBrokerAccessor.getMessageAnnotationProperty(amqpMessage, AMQPMirrorControllerSource.QUEUE), nodeID, messageID = (Long)(value = (AmqpValue)amqpMessage.getBody()).getValue(), messageAckOperation, ackReason)) {
                            messageAckOperation = null;
                        }
                    }
                } else if (this.sendMessage(amqpMessage, deliveryAnnotations, messageAckOperation)) {
                    messageAckOperation = null;
                }
            } else if (this.sendMessage(message, deliveryAnnotations, messageAckOperation)) {
                messageAckOperation = null;
            }
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
        finally {
            AMQPMirrorControllerTarget.setControllerInUse(null);
            if (messageAckOperation != null) {
                this.server.getStorageManager().afterCompleteOperations((IOCallback)messageAckOperation);
            }
        }
    }

    @Override
    public void initialize() throws Exception {
        this.initialized = true;
        this.receiver.setSenderSettleMode(this.receiver.getRemoteSenderSettleMode());
        this.receiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
        this.flow();
    }

    @Override
    protected MessageReader trySelectMessageReader(Receiver receiver, Delivery delivery) {
        if (delivery.getMessageFormat() == 1183580416) {
            return this.coreMessageReader != null ? this.coreMessageReader : (this.coreMessageReader = new AMQPTunneledCoreMessageReader(this));
        }
        if (delivery.getMessageFormat() == 1183580672) {
            return this.coreLargeMessageReader != null ? this.coreLargeMessageReader : (this.coreLargeMessageReader = new AMQPTunneledCoreLargeMessageReader(this));
        }
        return super.trySelectMessageReader(receiver, delivery);
    }

    private QueueConfiguration parseQueue(AMQPMessage message) {
        AmqpValue bodyValue = (AmqpValue)message.getBody();
        String body = (String)bodyValue.getValue();
        return QueueConfiguration.fromJSON((String)body);
    }

    private AddressInfo parseAddress(AMQPMessage message) {
        AmqpValue bodyValue = (AmqpValue)message.getBody();
        String body = (String)bodyValue.getValue();
        return AddressInfo.fromJSON((String)body);
    }

    public void preAcknowledge(Transaction tx, MessageReference ref, AckReason reason) throws Exception {
    }

    public void addAddress(AddressInfo addressInfo) throws Exception {
        logger.debug("{} adding address {}", (Object)this.server, (Object)addressInfo);
        this.server.addAddressInfo(addressInfo);
    }

    public void deleteAddress(AddressInfo addressInfo) throws Exception {
        logger.debug("{} delete address {}", (Object)this.server, (Object)addressInfo);
        try {
            this.server.removeAddressInfo(addressInfo.getName(), null, true);
        }
        catch (ActiveMQAddressDoesNotExistException expected) {
            logger.debug(expected.getMessage(), (Throwable)expected);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void createQueue(QueueConfiguration queueConfiguration) throws Exception {
        logger.debug("{} adding queue {}", (Object)this.server, (Object)queueConfiguration);
        try {
            this.server.createQueue(queueConfiguration, true);
        }
        catch (Exception e) {
            logger.debug("Queue could not be created, already existed {}", (Object)queueConfiguration, (Object)e);
        }
    }

    public void deleteQueue(SimpleString addressName, SimpleString queueName) throws Exception {
        block3: {
            if (logger.isDebugEnabled()) {
                logger.debug("{} destroy queue {} on address = {} server {}", new Object[]{this.server, queueName, addressName, this.server.getIdentity()});
            }
            try {
                this.server.destroyQueue(queueName, null, false, true, false, false);
            }
            catch (ActiveMQNonExistentQueueException expected) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("{} queue {} was previously removed", new Object[]{this.server, queueName, expected});
            }
        }
    }

    public boolean postAcknowledge(String queue, String nodeID, long messageID, ACKMessageOperation ackMessage, AckReason reason) throws Exception {
        Queue targetQueue = this.server.locateQueue(queue);
        if (targetQueue == null) {
            logger.warn("Queue {} not found on mirror target, ignoring ack for queue={}, messageID={}, nodeID={}", new Object[]{queue, queue, messageID, nodeID});
            return false;
        }
        if (logger.isDebugEnabled() && targetQueue.getConsumerCount() > 0) {
            logger.debug("server {}, queue {} has consumers while delivering ack for {}", new Object[]{this.server.getIdentity(), targetQueue.getName(), messageID});
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Server {} with queue = {} being acked for {} from {} targetQueue = {} reason = {}", new Object[]{this.server.getIdentity(), queue, messageID, ackMessage, targetQueue, reason});
        }
        this.performAck(nodeID, targetQueue, messageID, ackMessage, reason);
        return true;
    }

    private void performAck(String nodeID, Queue targetQueue, long messageID, ACKMessageOperation ackMessageOperation, AckReason reason) {
        if (logger.isTraceEnabled()) {
            logger.trace("performAck (nodeID={}, messageID={}), targetQueue={})", new Object[]{nodeID, messageID, targetQueue.getName()});
        }
        if (this.ackManager == null) {
            this.ackManager = AckManagerProvider.getManager(this.server);
        }
        this.ackManager.ack(nodeID, targetQueue, messageID, reason, true);
        OperationContextImpl.getContext().executeOnCompletion((IOCallback)ackMessageOperation);
    }

    private boolean sendMessage(Message message, DeliveryAnnotations deliveryAnnotations, ACKMessageOperation messageCompletionAck) throws Exception {
        DuplicateIDCache duplicateIDCache;
        String internalMirrorID;
        if (message.getMessageID() <= 0L) {
            message.setMessageID(this.server.getStorageManager().generateID());
        }
        if ((internalMirrorID = (String)deliveryAnnotations.getValue().get(AMQPMirrorControllerSource.BROKER_ID)) == null) {
            internalMirrorID = this.getRemoteMirrorId();
        }
        Long internalIDLong = (Long)deliveryAnnotations.getValue().get(AMQPMirrorControllerSource.INTERNAL_ID);
        String internalAddress = (String)deliveryAnnotations.getValue().get(AMQPMirrorControllerSource.INTERNAL_DESTINATION);
        Collection targetQueues = (Collection)deliveryAnnotations.getValue().get(AMQPMirrorControllerSource.TARGET_QUEUES);
        long internalID = 0L;
        if (internalIDLong != null) {
            internalID = internalIDLong;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("sendMessage on server {} for message {} with internalID = {} mirror id {}", new Object[]{this.server, message, internalIDLong, internalMirrorID});
        }
        this.routingContext.setDuplicateDetection(false);
        if (this.lruDuplicateIDKey != null && this.lruDuplicateIDKey.equals(internalMirrorID)) {
            duplicateIDCache = this.lruduplicateIDCache;
        } else {
            logger.trace("Setting up duplicate detection cache on {}, ServerID={} with {} elements, being the number of credits", new Object[]{"$ACTIVEMQ_ARTEMIS_MIRROR", internalMirrorID, this.connection.getAmqpCredits()});
            this.lruDuplicateIDKey = internalMirrorID;
            duplicateIDCache = this.lruduplicateIDCache = this.server.getPostOffice().getDuplicateIDCache(SimpleString.of((String)("$ACTIVEMQ_ARTEMIS_MIRROR_" + internalMirrorID)), this.connection.getAmqpCredits());
        }
        byte[] duplicateIDBytes = ByteUtil.longToBytes((long)internalIDLong);
        if (duplicateIDCache.contains(duplicateIDBytes)) {
            message.usageDown();
            this.flow();
            return false;
        }
        message.setBrokerProperty(AMQPMirrorControllerSource.INTERNAL_ID_EXTRA_PROPERTY, (Object)internalID);
        message.setBrokerProperty(AMQPMirrorControllerSource.INTERNAL_BROKER_ID_EXTRA_PROPERTY, (Object)internalMirrorID);
        if (internalAddress != null) {
            message.setAddress(internalAddress);
        }
        TransactionImpl transaction = new MirrorTransaction(this.server.getStorageManager()).setAllowPageTransaction(this.configuration.isMirrorPageTransaction()).setAsync(true);
        transaction.addOperation((TransactionOperation)messageCompletionAck.tx);
        this.routingContext.setTransaction((Transaction)transaction);
        duplicateIDCache.addToCache(duplicateIDBytes, (Transaction)transaction);
        this.routingContext.clear().setMirrorSource((MirrorController)this).setLoadBalancingType(MessageLoadBalancingType.LOCAL_ONLY);
        if (targetQueues != null) {
            this.targetQueuesRouting(message, (RoutingContext)this.routingContext, targetQueues);
            this.server.getPostOffice().processRoute(message, (RoutingContext)this.routingContext, false);
        } else {
            this.server.getPostOffice().route(message, (RoutingContext)this.routingContext, false);
        }
        transaction.commit();
        this.flow();
        return true;
    }

    private void targetQueuesRouting(Message message, RoutingContext context, Collection<String> queueNames) throws Exception {
        Bindings bindings = this.server.getPostOffice().getBindingsForAddress(message.getAddressSimpleString());
        queueNames.forEach(name -> {
            Binding binding = bindings.getBinding(name);
            if (binding != null) {
                try {
                    binding.route(message, context);
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    public void postAcknowledge(MessageReference ref, AckReason reason) {
    }

    public void sendMessage(Transaction tx, Message message, RoutingContext context) {
    }

    class ACKMessageOperation
    implements IOCallback,
    Runnable {
        Delivery delivery;
        public TransactionOperationAbstract tx = new TransactionOperationAbstract(){

            public void afterCommit(Transaction tx) {
                ACKMessageOperation.this.connectionRun();
            }
        };

        ACKMessageOperation() {
        }

        void reset() {
            this.delivery = null;
        }

        ACKMessageOperation setDelivery(Delivery delivery) {
            this.delivery = delivery;
            return this;
        }

        @Override
        public void run() {
            if (!AMQPMirrorControllerTarget.this.connection.isHandler()) {
                logger.info("Moving execution to proton handler");
                this.connectionRun();
                return;
            }
            logger.trace("Delivery settling for {}, context={}", (Object)this.delivery, this.delivery.getContext());
            this.delivery.disposition((DeliveryState)Accepted.getInstance());
            AMQPMirrorControllerTarget.this.settle(this.delivery);
            AMQPMirrorControllerTarget.this.connection.flush();
            AMQPMirrorControllerTarget.this.ackMessageMpscPool.release((Object)this);
        }

        public void done() {
            this.connectionRun();
        }

        public void connectionRun() {
            AMQPMirrorControllerTarget.this.connection.runNow(this);
        }

        public void onError(int errorCode, String errorMessage) {
            logger.warn("{}-{}", (Object)errorCode, (Object)errorMessage);
        }
    }
}

