/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageSupport;
import org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper.ConversionException;
import org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper.CoreBytesMessageWrapper;
import org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper.CoreMapMessageWrapper;
import org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper.CoreObjectMessageWrapper;
import org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper.CoreStreamMessageWrapper;
import org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper.CoreTextMessageWrapper;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreMessageWrapper {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final ICoreMessage message;
    private ActiveMQBuffer readBodyBuffer;

    public CoreMessageWrapper(ICoreMessage message) {
        this.message = message;
    }

    public static CoreMessageWrapper wrap(ICoreMessage wrapped) {
        switch (wrapped.getType()) {
            case 6: {
                return new CoreStreamMessageWrapper(wrapped);
            }
            case 4: {
                return new CoreBytesMessageWrapper(wrapped);
            }
            case 5: {
                return new CoreMapMessageWrapper(wrapped);
            }
            case 3: {
                return new CoreTextMessageWrapper(wrapped);
            }
            case 2: {
                return new CoreObjectMessageWrapper(wrapped);
            }
        }
        return new CoreMessageWrapper(wrapped);
    }

    protected short getOrignalEncoding() {
        short orignalEncoding = 0;
        try {
            orignalEncoding = this.message.getShortProperty("JMS_AMQP_ORIGINAL_ENCODING");
        }
        catch (Exception ex) {
            logger.debug(ex.getMessage(), (Throwable)ex);
        }
        return orignalEncoding;
    }

    public Section createAMQPSection(Map<Symbol, Object> maMap, Properties properties) throws ConversionException {
        maMap.put(AMQPMessageSupport.JMS_MSG_TYPE, (byte)0);
        ICoreMessage internalMessage = this.getInnerMessage();
        ActiveMQBuffer buffer = internalMessage.getDataBuffer();
        try {
            SimpleString s;
            if (buffer.readableBytes() > 0 && (s = buffer.readNullableSimpleString()) != null) {
                return new AmqpValue((Object)s.toString());
            }
            return null;
        }
        catch (Throwable e) {
            logger.debug("Exception ignored during conversion {}", (Object)e.getMessage(), (Object)e);
            return new AmqpValue((Object)("Conversion to AMQP error: " + e.getMessage()));
        }
    }

    public ICoreMessage getInnerMessage() {
        return this.message;
    }

    protected ActiveMQBuffer getReadBodyBuffer() {
        if (this.readBodyBuffer == null) {
            this.readBodyBuffer = this.message.getDataBuffer();
        }
        return this.readBodyBuffer;
    }

    protected ActiveMQBuffer getWriteBodyBuffer() {
        this.readBodyBuffer = null;
        return this.message.getBodyBuffer();
    }

    public final String getJMSMessageID() {
        if (this.message.containsProperty("NATIVE_MESSAGE_ID")) {
            return this.getStringProperty("NATIVE_MESSAGE_ID");
        }
        return null;
    }

    public final void setJMSMessageID(String id) {
        if (id != null) {
            this.message.putStringProperty("NATIVE_MESSAGE_ID", id);
        }
    }

    public final long getJMSTimestamp() {
        return this.message.getTimestamp();
    }

    public final void setJMSTimestamp(long timestamp) {
        this.message.setTimestamp(timestamp);
    }

    public final byte[] getJMSCorrelationIDAsBytes() {
        return MessageUtil.getJMSCorrelationIDAsBytes((Message)this.message);
    }

    public final void setJMSCorrelationIDAsBytes(byte[] correlationID) {
        this.message.setCorrelationID((Object)correlationID);
    }

    public final String getJMSCorrelationID() {
        Object correlationID = this.message.getCorrelationID();
        if (correlationID instanceof String) {
            return (String)correlationID;
        }
        if (correlationID != null) {
            return String.valueOf(correlationID);
        }
        return null;
    }

    public final void setJMSCorrelationID(String correlationID) {
        this.message.setCorrelationID((Object)correlationID);
    }

    public final SimpleString getJMSReplyTo() {
        return MessageUtil.getJMSReplyTo((Message)this.message);
    }

    public final void setJMSReplyTo(String replyTo) {
        MessageUtil.setJMSReplyTo((Message)this.message, (SimpleString)SimpleString.of((String)replyTo));
    }

    public SimpleString getDestination() {
        if (this.message.getAddress() == null || this.message.getAddress().isEmpty()) {
            return null;
        }
        return SimpleString.of((String)AMQPMessageSupport.destination(this.message.getRoutingType(), this.message.getAddress()));
    }

    public final void setDestination(String destination) {
        this.message.setAddress(destination);
    }

    public final int getJMSDeliveryMode() {
        return this.message.isDurable() ? 2 : 1;
    }

    public final void setDeliveryMode(int deliveryMode) throws ConversionException {
        switch (deliveryMode) {
            case 2: {
                this.message.setDurable(true);
                break;
            }
            case 1: {
                this.message.setDurable(false);
                break;
            }
            default: {
                throw new ConversionException("Invalid mode " + deliveryMode);
            }
        }
    }

    public final String getJMSType() {
        return MessageUtil.getJMSType((Message)this.message);
    }

    public final void setJMSType(String type) {
        MessageUtil.setJMSType((Message)this.message, (String)type);
    }

    public final long getExpiration() {
        return this.message.getExpiration();
    }

    public final void setJMSExpiration(long expiration) {
        this.message.setExpiration(expiration);
    }

    public final int getJMSPriority() {
        return this.message.getPriority();
    }

    public final void setJMSPriority(int priority) {
        this.message.setPriority((byte)priority);
    }

    public final void clearProperties() {
        MessageUtil.clearProperties((Message)this.message);
    }

    public final boolean propertyExists(String name) {
        return MessageUtil.propertyExists((Message)this.message, (String)name);
    }

    public final boolean getBooleanProperty(String name) {
        return this.message.getBooleanProperty(name);
    }

    public final byte getByteProperty(String name) {
        return this.message.getByteProperty(name);
    }

    public final short getShortProperty(String name) {
        return this.message.getShortProperty(name);
    }

    public final int getIntProperty(String name) {
        return MessageUtil.getIntProperty((Message)this.message, (String)name);
    }

    public final long getLongProperty(String name) {
        return MessageUtil.getLongProperty((Message)this.message, (String)name);
    }

    public final float getFloatProperty(String name) {
        return this.message.getFloatProperty(name).floatValue();
    }

    public final double getDoubleProperty(String name) {
        return this.message.getDoubleProperty(name);
    }

    public final String getStringProperty(String name) {
        return MessageUtil.getStringProperty((Message)this.message, (String)name);
    }

    public final Object getObjectProperty(String name) {
        return MessageUtil.getObjectProperty((Message)this.message, (String)name);
    }

    public final Enumeration getPropertyNames() {
        return Collections.enumeration(MessageUtil.getPropertyNames((Message)this.message));
    }

    public final void setBooleanProperty(String name, boolean value) {
        this.message.putBooleanProperty(name, value);
    }

    public final void setByteProperty(String name, byte value) {
        this.message.putByteProperty(name, value);
    }

    public final void setShortProperty(String name, short value) {
        this.message.putShortProperty(name, value);
    }

    public final void setIntProperty(String name, int value) {
        MessageUtil.setIntProperty((Message)this.message, (String)name, (int)value);
    }

    public final void setLongProperty(String name, long value) {
        MessageUtil.setLongProperty((Message)this.message, (String)name, (long)value);
    }

    public final void setFloatProperty(String name, float value) {
        this.message.putFloatProperty(name, value);
    }

    public final void setDoubleProperty(String name, double value) {
        this.message.putDoubleProperty(name, value);
    }

    public final void setStringProperty(String name, String value) {
        MessageUtil.setStringProperty((Message)this.message, (String)name, (String)value);
    }

    public final void setObjectProperty(String name, Object value) {
        MessageUtil.setObjectProperty((Message)this.message, (String)name, (Object)value);
    }

    public void clearBody() {
        this.message.getBodyBuffer().clear();
    }

    public void encode() {
        if (!this.message.isLargeMessage()) {
            this.message.getBodyBuffer().resetReaderIndex();
        }
    }

    public void decode() {
        if (!this.message.isLargeMessage()) {
            this.message.getBodyBuffer().resetReaderIndex();
        }
    }
}

