/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.sasl;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.protocol.amqp.broker.AmqpInterceptor;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManager;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPRoutingHandler;
import org.apache.activemq.artemis.protocol.amqp.sasl.GSSAPIServerSASL;
import org.apache.activemq.artemis.protocol.amqp.sasl.ServerSASL;
import org.apache.activemq.artemis.protocol.amqp.sasl.ServerSASLFactory;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSSAPIServerSASLFactory
implements ServerSASLFactory {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public String getMechanism() {
        return "GSSAPI";
    }

    @Override
    public ServerSASL create(ActiveMQServer server, ProtocolManager<AmqpInterceptor, AMQPRoutingHandler> manager, Connection connection, RemotingConnection remotingConnection) {
        if (manager instanceof ProtonProtocolManager) {
            GSSAPIServerSASL gssapiServerSASL = new GSSAPIServerSASL();
            gssapiServerSASL.setLoginConfigScope(((ProtonProtocolManager)manager).getSaslLoginConfigScope());
            return gssapiServerSASL;
        }
        logger.debug("SASL GSSAPI requires ProtonProtocolManager");
        return null;
    }

    @Override
    public int getPrecedence() {
        return 0;
    }

    @Override
    public boolean isDefaultPermitted() {
        return false;
    }
}

