/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.amqp;

import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.smallrye.reactive.messaging.ClientCustomizer;
import io.smallrye.reactive.messaging.amqp.AmqpConnectorCommonConfiguration;
import io.smallrye.reactive.messaging.amqp.i18n.AMQPExceptions;
import io.smallrye.reactive.messaging.amqp.i18n.AMQPLogging;
import io.smallrye.reactive.messaging.providers.helpers.CDIUtils;
import io.vertx.amqp.AmqpClientOptions;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.spi.tls.SslContextFactory;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.eclipse.microprofile.config.Config;

@ApplicationScoped
public class SslContextClientCustomizer
implements ClientCustomizer<AmqpClientOptions> {
    @Inject
    @Any
    private Instance<SSLContext> clientSslContexts;

    public AmqpClientOptions customize(String channel, Config channelConfig, AmqpClientOptions config) {
        SSLContext sslContext;
        AmqpConnectorCommonConfiguration commonConfiguration = new AmqpConnectorCommonConfiguration(channelConfig);
        Optional<String> clientSslContextName = commonConfiguration.getClientSslContextName();
        if (clientSslContextName.isPresent() && (sslContext = (SSLContext)CDIUtils.getInstanceById(this.clientSslContexts, (String)clientSslContextName.get(), () -> null)) != null) {
            try {
                config.setSslEngineOptions((SSLEngineOptions)new JdkSSLEngineOptions(){

                    public SslContextFactory sslContextFactory() {
                        return new SslContextFactory(){

                            public SslContext create() {
                                return new JdkSslContext(sslContext, true, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, ApplicationProtocolConfig.DISABLED, ClientAuth.NONE, null, false);
                            }
                        };
                    }
                });
            }
            catch (Exception e) {
                AMQPLogging.log.unableToCreateClient(e);
                throw AMQPExceptions.ex.illegalStateUnableToCreateClient(e);
            }
        }
        return config;
    }
}

