/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.massindexing.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassIdentifierLoader;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassIdentifierLoadingContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassIdentifierSink;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassLoadingContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassLoadingStrategy;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingEnvironment;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingFailureHandledRunnable;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingIndexedTypeGroup;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingNotifier;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoProducerConsumerQueue;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoMassIndexingEntityIdentifierLoadingRunnable<E, I>
extends PojoMassIndexingFailureHandledRunnable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoMassIndexingContext massIndexingContext;
    private final PojoMassIndexingIndexedTypeGroup<E> typeGroup;
    private final PojoMassLoadingStrategy<E, I> loadingStrategy;
    private final PojoProducerConsumerQueue<List<I>> identifierQueue;
    private final String tenantId;
    private final MassIndexingEnvironment.EntityIdentifierLoadingContext identifierLoadingContext;

    public PojoMassIndexingEntityIdentifierLoadingRunnable(PojoMassIndexingNotifier notifier, PojoMassIndexingContext massIndexingContext, MassIndexingEnvironment environment, PojoMassIndexingIndexedTypeGroup<E> typeGroup, PojoMassLoadingStrategy<E, I> loadingStrategy, PojoProducerConsumerQueue<List<I>> identifierQueue, String tenantId) {
        super(notifier, environment);
        this.massIndexingContext = massIndexingContext;
        this.loadingStrategy = loadingStrategy;
        this.typeGroup = typeGroup;
        this.identifierQueue = identifierQueue;
        this.tenantId = tenantId;
        this.identifierLoadingContext = new EntityIdentifierLoadingContextImpl();
    }

    @Override
    protected void runWithFailureHandler() throws InterruptedException {
        log.trace("started");
        LoadingContext context = new LoadingContext();
        try (PojoMassIdentifierLoader loader = this.loadingStrategy.createIdentifierLoader(this.typeGroup.includedTypes(), context);){
            long totalCount = loader.totalCount();
            this.getNotifier().reportAddedTotalCount(totalCount);
            do {
                loader.loadNext();
            } while (!context.done);
            this.identifierQueue.producerStopping();
        }
        log.trace("finished");
    }

    @Override
    protected void cleanUpOnFailure() {
    }

    @Override
    protected void cleanUpOnInterruption() {
    }

    @Override
    protected MassIndexingEnvironment.Context createMassIndexingEnvironmentContext() {
        return this.identifierLoadingContext;
    }

    @Override
    protected boolean supportsThreadLifecycleHooks() {
        return true;
    }

    @Override
    protected String operationName() {
        return log.massIndexerFetchingIds(this.typeGroup.notifiedGroupName());
    }

    private static final class EntityIdentifierLoadingContextImpl
    implements MassIndexingEnvironment.EntityIdentifierLoadingContext {
        private EntityIdentifierLoadingContextImpl() {
        }
    }

    private class LoadingContext
    implements PojoMassIdentifierLoadingContext<I> {
        private boolean done = false;

        private LoadingContext() {
        }

        @Override
        public PojoMassLoadingContext parent() {
            return PojoMassIndexingEntityIdentifierLoadingRunnable.this.massIndexingContext;
        }

        @Override
        public PojoMassIdentifierSink<I> createSink() {
            return new PojoMassIdentifierSink<I>(){

                @Override
                public void accept(List<? extends I> batch) throws InterruptedException {
                    log.tracef("produced a list of ids %s", batch);
                    ArrayList copy = new ArrayList(batch);
                    PojoMassIndexingEntityIdentifierLoadingRunnable.this.identifierQueue.put(copy);
                }

                @Override
                public void complete() {
                    LoadingContext.this.done = true;
                }
            };
        }

        @Override
        public String tenantIdentifier() {
            return PojoMassIndexingEntityIdentifierLoadingRunnable.this.tenantId;
        }
    }
}

