/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.hcann.spi;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Stream;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.hcann.spi.AbstractPojoHCAnnBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.hcann.spi.AbstractPojoHCAnnRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

public abstract class AbstractPojoHCAnnPropertyModel<T, I extends AbstractPojoHCAnnBootstrapIntrospector>
implements PojoPropertyModel<T> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final I introspector;
    protected final AbstractPojoHCAnnRawTypeModel<?, I> holderTypeModel;
    protected final String name;
    protected final List<XProperty> declaredXProperties;
    private final List<Member> members;
    private ValueReadHandle<T> handleCache;
    private PojoTypeModel<T> typeModelCache;
    private Member memberCache;

    public AbstractPojoHCAnnPropertyModel(I introspector, AbstractPojoHCAnnRawTypeModel<?, I> holderTypeModel, String name, List<XProperty> declaredXProperties, List<Member> members) {
        this.introspector = introspector;
        this.holderTypeModel = holderTypeModel;
        this.name = name;
        this.declaredXProperties = declaredXProperties;
        this.members = members;
        Contracts.assertNotNullNorEmpty(members, (String)"members");
    }

    @Override
    public final String name() {
        return this.name;
    }

    @Override
    public final Stream<Annotation> annotations() {
        return this.declaredXProperties.stream().flatMap(arg_0 -> this.introspector.annotations(arg_0));
    }

    @Override
    public final PojoTypeModel<T> typeModel() {
        if (this.typeModelCache == null) {
            try {
                this.typeModelCache = this.holderTypeModel.rawTypeDeclaringContext.memberTypeReference(this.getterGenericReturnType());
            }
            catch (RuntimeException e) {
                throw log.errorRetrievingPropertyTypeModel(this.name(), this.holderTypeModel, e);
            }
        }
        return this.typeModelCache;
    }

    @Override
    public final ValueReadHandle<T> handle() {
        if (this.handleCache == null) {
            try {
                this.handleCache = this.createHandle(this.member());
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                throw log.errorRetrievingPropertyTypeModel(this.name(), this.holderTypeModel, e);
            }
        }
        return this.handleCache;
    }

    protected final Member member() {
        if (this.memberCache == null) {
            this.memberCache = this.members.get(0);
            if (this.members.size() > 1) {
                log.arbitraryMemberSelection(this.holderTypeModel, this.name, this.memberCache, this.members.subList(1, this.members.size()));
            }
        }
        return this.memberCache;
    }

    protected abstract ValueReadHandle<T> createHandle(Member var1) throws ReflectiveOperationException;

    final Type getterGenericReturnType() {
        Member member = this.member();
        if (member instanceof Method) {
            return ((Method)member).getGenericReturnType();
        }
        if (member instanceof Field) {
            return ((Field)member).getGenericType();
        }
        throw new AssertionFailure("Unexpected type for a " + Member.class.getName() + ": " + String.valueOf(member) + " has type " + String.valueOf(member == null ? null : member.getClass()));
    }
}

