/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.security.FactoryPermissionCollection;
import org.jboss.modules.security.ModularPermissionFactory;
import org.jboss.modules.security.PermissionFactory;
import org.jboss.modules.xml.MXParser;
import org.jboss.modules.xml.ModuleXmlParser;
import org.jboss.modules.xml.PolicyExpander;
import org.jboss.modules.xml.XmlPullParser;
import org.jboss.modules.xml.XmlPullParserException;

public final class PermissionsXmlParser {
    public static FactoryPermissionCollection parsePermissionsXml(InputStream inputStream, ModuleLoader moduleLoader, String moduleName) throws XmlPullParserException, IOException {
        MXParser mxParser = new MXParser();
        mxParser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        mxParser.setInput(inputStream, null);
        return PermissionsXmlParser.parsePermissionsXml(mxParser, moduleLoader, moduleName);
    }

    public static FactoryPermissionCollection parsePermissionsXml(XmlPullParser reader, ModuleLoader moduleLoader, String moduleName) throws IOException, XmlPullParserException {
        while (true) {
            int eventType = reader.nextTag();
            switch (eventType) {
                case 2: {
                    PermissionsXmlParser.validateNamespace(reader);
                    switch (reader.getName()) {
                        case "permissions": {
                            return PermissionsXmlParser.parsePermissionsElement(reader, moduleLoader, moduleName);
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
                case 3: {
                    return new FactoryPermissionCollection(new PermissionFactory[0]);
                }
            }
        }
    }

    private static void validateNamespace(XmlPullParser reader) throws XmlPullParserException {
        String namespace = reader.getNamespace();
        if (namespace != null) {
            switch (namespace) {
                case "": 
                case "http://xmlns.jcp.org/xml/ns/javaee": 
                case "http://java.sun.com/xml/ns/javaee": 
                case "http://java.sun.com/xml/ns/j2ee": 
                case "http://java.sun.com/dtd": {
                    return;
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
    }

    private static FactoryPermissionCollection parsePermissionsElement(XmlPullParser reader, ModuleLoader moduleLoader, String moduleName) throws IOException, XmlPullParserException {
        int attributeCount = reader.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            if (!reader.getAttributeNamespace(i).isEmpty() || reader.getAttributeName(i).equals("version")) continue;
            throw ModuleXmlParser.unknownAttribute(reader, i);
        }
        ArrayList<PermissionFactory> factories = new ArrayList<PermissionFactory>();
        while (true) {
            int eventType = reader.nextTag();
            block0 : switch (eventType) {
                case 2: {
                    PermissionsXmlParser.validateNamespace(reader);
                    switch (reader.getName()) {
                        case "permission": {
                            factories.add(PermissionsXmlParser.parsePermissionElement(reader, moduleLoader, moduleName));
                            break block0;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
                case 3: {
                    return new FactoryPermissionCollection((PermissionFactory[])factories.toArray(PermissionFactory[]::new));
                }
            }
        }
    }

    private static PermissionFactory parsePermissionElement(XmlPullParser reader, ModuleLoader moduleLoader, String moduleName) throws IOException, XmlPullParserException {
        if (reader.getAttributeCount() > 0) {
            throw ModuleXmlParser.unknownAttribute(reader, 0);
        }
        String className = null;
        String name = null;
        String actions = null;
        while (true) {
            int eventType = reader.nextTag();
            block0 : switch (eventType) {
                case 2: {
                    PermissionsXmlParser.validateNamespace(reader);
                    switch (reader.getName()) {
                        case "class-name": {
                            if (className != null) {
                                throw ModuleXmlParser.unexpectedContent(reader);
                            }
                            className = reader.nextText().trim();
                            break block0;
                        }
                        case "name": {
                            if (className == null || name != null || actions != null) {
                                throw ModuleXmlParser.unexpectedContent(reader);
                            }
                            name = PolicyExpander.expand(reader.nextText().trim());
                            break block0;
                        }
                        case "actions": {
                            if (className == null || actions != null) {
                                throw ModuleXmlParser.unexpectedContent(reader);
                            }
                            actions = reader.nextText().trim();
                            break block0;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
                case 3: {
                    return new ModularPermissionFactory(moduleLoader, moduleName, className, name, actions);
                }
            }
        }
    }
}

