/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.commit;

import io.smallrye.common.annotation.Identifier;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.kafka.IncomingKafkaRecord;
import io.smallrye.reactive.messaging.kafka.KafkaConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.kafka.KafkaConsumer;
import io.smallrye.reactive.messaging.kafka.commit.ContextHolder;
import io.smallrye.reactive.messaging.kafka.commit.KafkaCommitHandler;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaLogging;
import io.smallrye.reactive.messaging.kafka.impl.TopicPartitions;
import io.vertx.mutiny.core.Vertx;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;

public class KafkaLatestCommit
extends ContextHolder
implements KafkaCommitHandler {
    private KafkaConsumer<?, ?> consumer;
    private final Map<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();

    public KafkaLatestCommit(Vertx vertx, KafkaConnectorIncomingConfiguration configuration, KafkaConsumer<?, ?> consumer) {
        super(vertx, configuration.config().getOptionalValue("default.api.timeout.ms", Integer.class).orElse(60000));
        this.consumer = consumer;
    }

    @Override
    public <K, V> Uni<Void> handle(IncomingKafkaRecord<K, V> record) {
        this.runOnContext(() -> {
            HashMap<TopicPartition, OffsetAndMetadata> map = new HashMap<TopicPartition, OffsetAndMetadata>();
            TopicPartition key = TopicPartitions.getTopicPartition(record);
            Long last = this.offsets.get(key);
            if (last == null || last < record.getOffset() + 1L) {
                this.offsets.put(key, record.getOffset() + 1L);
                map.put(key, new OffsetAndMetadata(record.getOffset() + 1L, null));
                this.consumer.commitAsync(map).subscribe().with(ignored -> {}, throwable -> KafkaLogging.log.failedToCommitAsync(key, record.getOffset() + 1L, (Throwable)throwable));
            }
        });
        return Uni.createFrom().voidItem().runSubscriptionOn(arg_0 -> record.runOnMessageContext(arg_0));
    }

    @ApplicationScoped
    @Identifier(value="latest")
    public static class Factory
    implements KafkaCommitHandler.Factory {
        @Override
        public KafkaLatestCommit create(KafkaConnectorIncomingConfiguration config, Vertx vertx, KafkaConsumer<?, ?> consumer, BiConsumer<Throwable, Boolean> reportFailure) {
            return new KafkaLatestCommit(vertx, config, consumer);
        }
    }
}

