/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.CommonServiceDescriptor;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.controller.security.CredentialReferenceWriteAttributeHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jgroups.protocols.Encrypt;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ServiceDependency;

public class EncryptProtocolResourceDefinition<E extends KeyStore.Entry, P extends Encrypt<E>>
extends ProtocolResourceDefinition<P> {
    private final Class<E> entryClass;

    public EncryptProtocolResourceDefinition(String name, Class<E> entryClass, UnaryOperator<ResourceDescriptor> configurator, ResourceServiceConfigurator parentServiceConfigurator) {
        super(EncryptProtocolResourceDefinition.pathElement(name), new ResourceDescriptorConfigurator(configurator), parentServiceConfigurator);
        this.entryClass = entryClass;
    }

    @Override
    public Map.Entry<Function<ProtocolConfiguration<P>, ProtocolConfiguration<P>>, Consumer<RequirementServiceBuilder<?>>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        String keyStoreName = Attribute.KEY_STORE.resolveModelAttribute((ExpressionResolver)context, model).asString();
        final String keyAlias = Attribute.KEY_ALIAS.resolveModelAttribute((ExpressionResolver)context, model).asString();
        final Class<E> entryClass = this.entryClass;
        final ServiceDependency keyStore = ServiceDependency.on((UnaryServiceDescriptor)CommonServiceDescriptor.KEY_STORE, (String)keyStoreName);
        final ServiceDependency credentialSource = ServiceDependency.from((org.wildfly.service.ServiceDependency)CredentialReference.getCredentialSourceDependency((OperationContext)context, (AttributeDefinition)Attribute.KEY_CREDENTIAL.getDefinition(), (ModelNode)model));
        return Map.entry(new UnaryOperator<ProtocolConfiguration<P>>(){

            @Override
            public ProtocolConfiguration<P> apply(ProtocolConfiguration<P> configuration) {
                return new AbstractProtocolResourceDefinition.ProtocolConfigurationDecorator<P>(configuration){

                    @Override
                    public P createProtocol(ProtocolStackConfiguration stackConfiguration) {
                        Encrypt protocol = (Encrypt)super.createProtocol(stackConfiguration);
                        KeyStore store = (KeyStore)keyStore.get();
                        try {
                            if (!store.containsAlias(keyAlias)) {
                                throw JGroupsLogger.ROOT_LOGGER.keyEntryNotFound(keyAlias);
                            }
                            PasswordCredential credential = (PasswordCredential)((CredentialSource)credentialSource.get()).getCredential(PasswordCredential.class);
                            if (credential == null) {
                                throw JGroupsLogger.ROOT_LOGGER.unexpectedCredentialSource();
                            }
                            ClearPassword password = (ClearPassword)credential.getPassword(ClearPassword.class);
                            if (password == null) {
                                throw JGroupsLogger.ROOT_LOGGER.unexpectedCredentialSource();
                            }
                            if (!store.entryInstanceOf(keyAlias, entryClass)) {
                                throw JGroupsLogger.ROOT_LOGGER.unexpectedKeyStoreEntryType(keyAlias, entryClass.getSimpleName());
                            }
                            KeyStore.Entry entry = store.getEntry(keyAlias, new KeyStore.PasswordProtection(password.getPassword()));
                            protocol.setKeyStoreEntry((KeyStore.Entry)entryClass.cast(entry));
                        }
                        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException e) {
                            throw new IllegalArgumentException(e);
                        }
                        return protocol;
                    }
                };
            }
        }, keyStore.andThen((Consumer)credentialSource));
    }

    private static class ResourceDescriptorConfigurator
    implements UnaryOperator<ResourceDescriptor> {
        private final UnaryOperator<ResourceDescriptor> configurator;

        ResourceDescriptorConfigurator(UnaryOperator<ResourceDescriptor> configurator) {
            this.configurator = configurator;
        }

        @Override
        public ResourceDescriptor apply(ResourceDescriptor descriptor) {
            return ((ResourceDescriptor)this.configurator.apply(descriptor)).addAttributes(EnumSet.complementOf(EnumSet.of(Attribute.KEY_CREDENTIAL))).addAttribute((org.jboss.as.clustering.controller.Attribute)Attribute.KEY_CREDENTIAL, (OperationStepHandler)new CredentialReferenceWriteAttributeHandler(Attribute.KEY_CREDENTIAL.getDefinition())).setAddOperationTransformation((UnaryOperator)new ProtocolResourceDefinition.LegacyAddOperationTransformation(Attribute.class)).setOperationTransformation(ProtocolResourceDefinition.LEGACY_OPERATION_TRANSFORMER);
        }
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        KEY_CREDENTIAL((AttributeDefinition)CredentialReference.getAttributeBuilder((String)"key-credential-reference", null, (boolean)false, (CapabilityReferenceRecorder)org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder.builder(ProtocolResourceDefinition.CAPABILITY, (UnaryServiceDescriptor)CommonServiceDescriptor.CREDENTIAL_STORE).build()).build()),
        KEY_ALIAS("key-alias", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setAllowExpression(true);
            }
        }
        ,
        KEY_STORE("key-store", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setCapabilityReference((CapabilityReferenceRecorder)org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder.builder(ProtocolResourceDefinition.CAPABILITY, (UnaryServiceDescriptor)CommonServiceDescriptor.KEY_STORE).build());
            }
        };

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type) {
            this.definition = this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setRequired(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        private Attribute(AttributeDefinition definition) {
            this.definition = definition;
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
            return builder;
        }
    }
}

