/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.model.impl;

import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.apache.lucene.codecs.Codec;
import org.hibernate.search.backend.lucene.document.model.impl.AbstractLuceneIndexFieldTemplate;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexField;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexRoot;
import org.hibernate.search.backend.lucene.lowlevel.codec.impl.HibernateSearchLuceneCodec;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.AnalyzerConstants;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexValueFieldType;
import org.hibernate.search.engine.backend.analysis.spi.AnalysisDescriptorRegistry;
import org.hibernate.search.engine.backend.document.model.spi.AbstractIndexModel;
import org.hibernate.search.engine.backend.document.model.spi.IndexCompositeNode;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldFilter;
import org.hibernate.search.engine.backend.document.model.spi.IndexIdentifier;
import org.hibernate.search.engine.backend.metamodel.IndexDescriptor;

public class LuceneIndexModel
extends AbstractIndexModel<LuceneIndexModel, LuceneIndexRoot, LuceneIndexField>
implements AutoCloseable,
IndexDescriptor {
    private final boolean hasNestedDocuments;
    private final IndexingScopedAnalyzer indexingAnalyzer = new IndexingScopedAnalyzer();
    private final SearchScopedAnalyzer searchAnalyzer = new SearchScopedAnalyzer();
    private final Codec codec;

    public LuceneIndexModel(AnalysisDescriptorRegistry analysisDescriptorRegistry, String hibernateSearchName, String mappedTypeName, IndexIdentifier identifier, LuceneIndexRoot rootNode, Map<String, LuceneIndexField> staticFields, List<? extends AbstractLuceneIndexFieldTemplate<?>> fieldTemplates, boolean hasNestedDocuments) {
        super(analysisDescriptorRegistry, hibernateSearchName, mappedTypeName, identifier, (IndexCompositeNode)rootNode, staticFields, fieldTemplates);
        this.hasNestedDocuments = hasNestedDocuments;
        this.codec = new HibernateSearchLuceneCodec(this);
    }

    @Override
    public void close() {
        this.indexingAnalyzer.close();
    }

    protected LuceneIndexModel self() {
        return this;
    }

    public boolean hasNestedDocuments() {
        return this.hasNestedDocuments;
    }

    public Analyzer getIndexingAnalyzer() {
        return this.indexingAnalyzer;
    }

    public Analyzer getSearchAnalyzer() {
        return this.searchAnalyzer;
    }

    public Codec codec() {
        return this.codec;
    }

    private class IndexingScopedAnalyzer
    extends DelegatingAnalyzerWrapper {
        protected IndexingScopedAnalyzer() {
            super(PER_FIELD_REUSE_STRATEGY);
        }

        protected Analyzer getWrappedAnalyzer(String fieldName) {
            LuceneIndexField field = (LuceneIndexField)LuceneIndexModel.this.fieldOrNull(fieldName, IndexFieldFilter.ALL);
            if (field == null) {
                return AnalyzerConstants.KEYWORD_ANALYZER;
            }
            Analyzer analyzer = ((LuceneIndexValueFieldType)field.toValueField().type()).indexingAnalyzerOrNormalizer();
            if (analyzer == null) {
                return AnalyzerConstants.KEYWORD_ANALYZER;
            }
            return analyzer;
        }
    }

    private class SearchScopedAnalyzer
    extends DelegatingAnalyzerWrapper {
        protected SearchScopedAnalyzer() {
            super(PER_FIELD_REUSE_STRATEGY);
        }

        protected Analyzer getWrappedAnalyzer(String fieldName) {
            LuceneIndexField field = (LuceneIndexField)LuceneIndexModel.this.fieldOrNull(fieldName, IndexFieldFilter.ALL);
            if (field == null) {
                return AnalyzerConstants.KEYWORD_ANALYZER;
            }
            Analyzer analyzer = ((LuceneIndexValueFieldType)field.toValueField().type()).searchAnalyzerOrNormalizer();
            if (analyzer == null) {
                return AnalyzerConstants.KEYWORD_ANALYZER;
            }
            return analyzer;
        }
    }
}

