/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.comparator.impl;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.comparators.FloatComparator;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.DoubleMultiValuesToSingleValuesSource;

public class FloatValuesSourceComparator
extends FloatComparator {
    private final DoubleMultiValuesToSingleValuesSource source;

    public FloatValuesSourceComparator(int numHits, String field, Float missingValue, boolean reversed, Pruning ignored, DoubleMultiValuesToSingleValuesSource source) {
        super(numHits, field, missingValue, reversed, Pruning.NONE);
        this.source = source;
    }

    public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
        return new FloatValuesSourceLeafComparator(context);
    }

    private class FloatValuesSourceLeafComparator
    extends FloatComparator.FloatLeafComparator {
        FloatValuesSourceLeafComparator(LeafReaderContext context) throws IOException {
            super((FloatComparator)FloatValuesSourceComparator.this, context);
        }

        protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
            return FloatValuesSourceComparator.this.source.getValues(context, null).getRawFloatValues();
        }
    }
}

