/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.comparator.impl;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.comparators.IntComparator;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.LongMultiValuesToSingleValuesSource;

public class IntValuesSourceComparator
extends IntComparator {
    private final LongMultiValuesToSingleValuesSource source;

    public IntValuesSourceComparator(int numHits, String field, Integer missingValue, boolean reversed, Pruning ignored, LongMultiValuesToSingleValuesSource source) {
        super(numHits, field, missingValue, reversed, Pruning.NONE);
        this.source = source;
    }

    public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
        return new IntValuesSourceLeafComparator(context);
    }

    private class IntValuesSourceLeafComparator
    extends IntComparator.IntLeafComparator {
        IntValuesSourceLeafComparator(LeafReaderContext context) throws IOException {
            super((IntComparator)IntValuesSourceComparator.this, context);
        }

        protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
            return IntValuesSourceComparator.this.source.getRawNumericDocValues(context, null);
        }
    }
}

