/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.reader.impl;

import java.util.Map;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.LeafReaderContext;
import org.hibernate.search.util.common.AssertionFailure;

public final class IndexReaderMetadataResolver {
    private final Map<DirectoryReader, String> mappedTypeNameByDirectoryReader;

    IndexReaderMetadataResolver(Map<DirectoryReader, String> mappedTypeNameByDirectoryReader) {
        this.mappedTypeNameByDirectoryReader = mappedTypeNameByDirectoryReader;
    }

    public String resolveMappedTypeName(LeafReaderContext context) {
        return this.mappedTypeNameByDirectoryReader.get(this.getDirectoryReader(context));
    }

    private DirectoryReader getDirectoryReader(LeafReaderContext context) {
        LeafReaderContext current = context;
        while (current != null && !(current.reader() instanceof DirectoryReader)) {
            current = current.parent;
        }
        if (current == null) {
            throw new AssertionFailure("Unexpectedly got a reader context that has no DirectoryReader parent: " + String.valueOf(context));
        }
        return (DirectoryReader)current.reader();
    }
}

