/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.writer.impl;

import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterSettingValue;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterSettings;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.util.common.reporting.EventContext;

public class IndexWriterConfigSource {
    private final Similarity similarity;
    private final Analyzer analyzer;
    private final Codec codec;
    private final List<IndexWriterSettingValue<?>> values;

    public static IndexWriterConfigSource create(Similarity similarity, Analyzer analyzer, Codec codec, ConfigurationPropertySource propertySource, EventContext eventContext) {
        List<IndexWriterSettingValue<?>> values = IndexWriterSettings.extractAll(propertySource, eventContext);
        return new IndexWriterConfigSource(similarity, analyzer, codec, values);
    }

    private IndexWriterConfigSource(Similarity similarity, Analyzer analyzer, Codec codec, List<IndexWriterSettingValue<?>> values) {
        this.similarity = similarity;
        this.analyzer = analyzer;
        this.codec = codec;
        this.values = values;
    }

    public String toString() {
        return "IndexWriterConfigSource{" + String.valueOf(this.analyzer) + "," + String.valueOf(this.values) + "}";
    }

    public IndexWriterConfig createIndexWriterConfig() {
        IndexWriterConfig writerConfig = new IndexWriterConfig(this.analyzer);
        writerConfig.setSimilarity(this.similarity);
        writerConfig.setCodec(this.codec);
        for (IndexWriterSettingValue<?> value : this.values) {
            value.applySetting(writerConfig);
        }
        writerConfig.setMergePolicy((MergePolicy)this.createMergePolicy());
        return writerConfig;
    }

    private LogByteSizeMergePolicy createMergePolicy() {
        LogByteSizeMergePolicy logByteSizeMergePolicy = new LogByteSizeMergePolicy();
        for (IndexWriterSettingValue<?> value : this.values) {
            value.applySetting(logByteSizeMergePolicy);
        }
        return logByteSizeMergePolicy;
    }
}

