/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.QueryBuilder;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.AnalyzerConstants;
import org.hibernate.search.backend.lucene.lowlevel.query.impl.FuzzyQueryBuilder;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneCodecAwareSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneLeafSingleFieldPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneCommonMinimumShouldMatchConstraints;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.engine.search.common.ValueModel;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.MatchPredicateBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneTextMatchPredicate
extends AbstractLuceneLeafSingleFieldPredicate {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    private LuceneTextMatchPredicate(Builder<?> builder) {
        super(builder);
    }

    private static class Builder<F>
    extends AbstractLuceneLeafSingleFieldPredicate.AbstractBuilder<F>
    implements MatchPredicateBuilder {
        private final LuceneFieldCodec<F, String> codec;
        private final LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry;
        private final LuceneCommonMinimumShouldMatchConstraints minimumShouldMatchConstraints;
        private String value;
        private Integer maxEditDistance;
        private Integer prefixLength;
        private Analyzer overrideAnalyzerOrNormalizer;

        private Builder(LuceneFieldCodec<F, String> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            super(scope, field);
            this.codec = codec;
            this.analysisDefinitionRegistry = scope.analysisDefinitionRegistry();
            this.minimumShouldMatchConstraints = new LuceneCommonMinimumShouldMatchConstraints();
        }

        public void value(Object value, ValueModel valueModel) {
            this.value = this.convertAndEncode(this.codec, value, valueModel);
        }

        public void fuzzy(int maxEditDistance, int exactPrefixLength) {
            this.maxEditDistance = maxEditDistance;
            this.prefixLength = exactPrefixLength;
        }

        public void analyzer(String analyzerName) {
            this.overrideAnalyzerOrNormalizer = this.analysisDefinitionRegistry.getAnalyzerDefinition(analyzerName);
            if (this.overrideAnalyzerOrNormalizer == null) {
                throw log.unknownAnalyzer(analyzerName, this.field.eventContext());
            }
        }

        public void skipAnalysis() {
            this.overrideAnalyzerOrNormalizer = AnalyzerConstants.KEYWORD_ANALYZER;
        }

        public void minimumShouldMatchNumber(int ignoreConstraintCeiling, int matchingClausesNumber) {
            this.minimumShouldMatchConstraints.minimumShouldMatchNumber(ignoreConstraintCeiling, matchingClausesNumber);
        }

        public void minimumShouldMatchPercent(int ignoreConstraintCeiling, int matchingClausesPercent) {
            this.minimumShouldMatchConstraints.minimumShouldMatchPercent(ignoreConstraintCeiling, matchingClausesPercent);
        }

        public SearchPredicate build() {
            return new LuceneTextMatchPredicate(this);
        }

        @Override
        protected Query buildQuery(PredicateRequestContext context) {
            Analyzer effectiveAnalyzerOrNormalizer = this.overrideAnalyzerOrNormalizer;
            if (effectiveAnalyzerOrNormalizer == null) {
                effectiveAnalyzerOrNormalizer = this.field.type().searchAnalyzerOrNormalizer();
            }
            if (effectiveAnalyzerOrNormalizer == AnalyzerConstants.KEYWORD_ANALYZER) {
                Term term = new Term(this.absoluteFieldPath, this.value);
                if (this.maxEditDistance != null) {
                    return new FuzzyQuery(term, this.maxEditDistance.intValue(), this.prefixLength.intValue());
                }
                return new TermQuery(term);
            }
            QueryBuilder effectiveQueryBuilder = this.maxEditDistance != null ? new FuzzyQueryBuilder(effectiveAnalyzerOrNormalizer, this.maxEditDistance, this.prefixLength) : new QueryBuilder(effectiveAnalyzerOrNormalizer);
            Query analyzed = effectiveQueryBuilder.createBooleanQuery(this.absoluteFieldPath, this.value);
            if (analyzed == null) {
                analyzed = new MatchNoDocsQuery("No tokens after analysis of the value to match");
            }
            return this.minimumShouldMatchConstraints.apply(analyzed);
        }
    }

    public static class Factory<F>
    extends AbstractLuceneCodecAwareSearchQueryElementFactory<MatchPredicateBuilder, F, LuceneFieldCodec<F, String>> {
        public Factory(LuceneFieldCodec<F, String> codec) {
            super(codec);
        }

        @Override
        public Builder<F> create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            return new Builder<F>(this.codec, scope, field);
        }
    }
}

