/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.quorum;

import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.server.cluster.quorum.BooleanVote;

public class ServerConnectVote
extends BooleanVote {
    private String nodeId;
    private String transportConfiguration;

    public ServerConnectVote(String nodeId) {
        super(false);
        this.nodeId = nodeId;
    }

    public ServerConnectVote() {
        super(false);
    }

    public ServerConnectVote(String nodeid, boolean isPrimary, String transportConfiguration) {
        super(isPrimary);
        this.nodeId = nodeid;
        this.transportConfiguration = transportConfiguration;
    }

    @Override
    public boolean isRequestServerVote() {
        return true;
    }

    @Override
    public Map<String, Object> getVoteMap() {
        return null;
    }

    @Override
    public void encode(ActiveMQBuffer buff) {
        super.encode(buff);
        buff.writeString(this.nodeId);
        buff.writeNullableString(this.transportConfiguration);
    }

    public String getTransportConfiguration() {
        return this.transportConfiguration;
    }

    @Override
    public void decode(ActiveMQBuffer buff) {
        super.decode(buff);
        this.nodeId = buff.readString();
        this.transportConfiguration = buff.readNullableString();
    }

    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    public String toString() {
        return "ServerConnectVote [nodeId=" + this.nodeId + ", vote=" + this.vote + "]";
    }
}

