/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.federation;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.core.client.impl.ClientConsumerInternal;
import org.apache.activemq.artemis.core.client.impl.ClientLargeMessageInternal;
import org.apache.activemq.artemis.core.client.impl.ClientMessageInternal;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.LargeMessageControllerImpl;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.federation.FederatedConsumerKey;
import org.apache.activemq.artemis.core.server.federation.FederatedQueueConsumer;
import org.apache.activemq.artemis.core.server.federation.Federation;
import org.apache.activemq.artemis.core.server.federation.FederationUpstream;
import org.apache.activemq.artemis.core.server.transformer.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederatedQueueConsumerImpl
implements FederatedQueueConsumer,
SessionFailureListener {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ActiveMQServer server;
    private final Federation federation;
    private final FederatedConsumerKey key;
    private final Transformer transformer;
    private final FederationUpstream upstream;
    private final AtomicInteger count = new AtomicInteger();
    private final ScheduledExecutorService scheduledExecutorService;
    private final int intialConnectDelayMultiplier = 2;
    private final int intialConnectDelayMax = 30;
    private final ClientSessionCallback clientSessionCallback;
    private boolean started = false;
    private volatile ScheduledFuture currentConnectTask;
    private ClientSessionFactoryInternal clientSessionFactory;
    private ClientSession clientSession;
    private ClientConsumerInternal clientConsumer;
    private final AtomicInteger pendingPullCredit = new AtomicInteger();
    private QueueHandle queueHandle;

    public FederatedQueueConsumerImpl(Federation federation, ActiveMQServer server, Transformer transformer, FederatedConsumerKey key, FederationUpstream upstream, ClientSessionCallback clientSessionCallback) {
        this.federation = federation;
        this.server = server;
        this.key = key;
        this.transformer = transformer;
        this.upstream = upstream;
        this.scheduledExecutorService = server.getScheduledPool();
        this.clientSessionCallback = clientSessionCallback;
    }

    @Override
    public FederationUpstream getFederationUpstream() {
        return this.upstream;
    }

    @Override
    public Federation getFederation() {
        return this.federation;
    }

    @Override
    public FederatedConsumerKey getKey() {
        return this.key;
    }

    @Override
    public ClientSession getClientSession() {
        return this.clientSession;
    }

    @Override
    public int incrementCount() {
        return this.count.incrementAndGet();
    }

    @Override
    public int decrementCount() {
        return this.count.decrementAndGet();
    }

    @Override
    public synchronized void start() {
        if (!this.started) {
            this.started = true;
            this.scheduleConnect(0);
        }
    }

    private void scheduleConnect(int delay) {
        this.currentConnectTask = this.scheduledExecutorService.schedule(() -> {
            try {
                this.connect();
            }
            catch (Exception e) {
                int nextDelay = FederatedQueueConsumer.getNextDelay(delay, 2, 30);
                logger.trace("{} failed to connect. Scheduling reconnect in {} seconds.", new Object[]{this, nextDelay, e});
                this.scheduleConnect(nextDelay);
            }
        }, (long)delay, TimeUnit.SECONDS);
    }

    private synchronized void connect() throws Exception {
        block10: {
            if (this.started) {
                try {
                    ClientSession.QueueQuery queryResult;
                    if (this.clientConsumer != null) break block10;
                    this.clientSessionFactory = (ClientSessionFactoryInternal)this.upstream.getConnection().clientSessionFactory();
                    this.clientSession = this.clientSessionFactory.createSession(this.upstream.getUser(), this.upstream.getPassword(), false, true, true, this.clientSessionFactory.getServerLocator().isPreAcknowledge(), this.clientSessionFactory.getServerLocator().getAckBatchSize());
                    this.clientSession.addFailureListener((SessionFailureListener)this);
                    this.clientSession.addMetaData("federation-name", this.federation.getName().toString());
                    this.clientSession.addMetaData("federation-upstream-name", this.upstream.getName().toString());
                    this.clientSession.start();
                    if (this.clientSessionCallback != null) {
                        this.clientSessionCallback.callback(this.clientSession);
                    }
                    if ((queryResult = this.clientSession.queueQuery(this.key.getQueueName())).isExists()) {
                        this.clientConsumer = (ClientConsumerInternal)this.clientSession.createConsumer(this.key.getQueueName(), this.key.getFilterString(), this.key.getPriority(), false);
                        if (this.clientConsumer.getClientWindowSize() == 0) {
                            this.clientConsumer.setManualFlowMessageHandler((MessageHandler)this);
                            this.queueHandle = this.createQueueHandle(this.server, queryResult);
                            this.scheduleCreditOnEmpty(0, this.queueHandle);
                        } else {
                            this.clientConsumer.setMessageHandler((MessageHandler)this);
                        }
                        break block10;
                    }
                    throw new ActiveMQNonExistentQueueException("Queue " + this.key.getQueueName() + " does not exist on remote");
                }
                catch (Exception e) {
                    try {
                        if (this.clientSessionFactory != null) {
                            this.clientSessionFactory.cleanup();
                        }
                        this.disconnect();
                    }
                    catch (ActiveMQException activeMQException) {
                        // empty catch block
                    }
                    throw e;
                }
            }
        }
    }

    private QueueHandle createQueueHandle(ActiveMQServer server, ClientSession.QueueQuery queryResult) {
        final Queue queue = server.locateQueue(queryResult.getName());
        int creditWindow = 0x100000;
        Integer defaultConsumerWindowSize = queryResult.getDefaultConsumerWindowSize();
        if (defaultConsumerWindowSize != null && (creditWindow = defaultConsumerWindowSize.intValue()) <= 0) {
            creditWindow = 0x100000;
            logger.trace("{} override non positive queue consumerWindowSize with {}.", (Object)this, (Object)creditWindow);
        }
        final int finalCreditWindow = creditWindow;
        return new QueueHandle(){

            @Override
            public long getMessageCount() {
                return queue.getPendingMessageCount();
            }

            @Override
            public int getCreditWindow() {
                return finalCreditWindow;
            }

            @Override
            public Executor getExecutor() {
                return queue.getExecutor();
            }
        };
    }

    private void scheduleCreditOnEmpty(int delay, QueueHandle handle) {
        this.scheduledExecutorService.schedule(() -> handle.getExecutor().execute(() -> {
            if (this.clientConsumer != null) {
                if (0L == handle.getMessageCount()) {
                    this.flow(handle.getCreditWindow());
                    this.pendingPullCredit.set(handle.getCreditWindow());
                } else {
                    if (0 == delay) {
                        this.clientConsumer.resetIfSlowConsumer();
                        this.pendingPullCredit.set(0);
                    }
                    this.scheduleCreditOnEmpty(FederatedQueueConsumer.getNextDelay(delay, 2, 30), handle);
                }
            }
        }), (long)delay, TimeUnit.SECONDS);
    }

    private void flow(int creditWindow) {
        try {
            if (this.clientConsumer != null) {
                this.clientConsumer.flowControl(creditWindow, false);
            }
        }
        catch (ActiveMQException ignored) {
            logger.trace("{} failed to flowControl with credit {}.", new Object[]{this, creditWindow, ignored});
        }
    }

    @Override
    public synchronized void close() {
        if (this.started) {
            this.started = false;
            this.currentConnectTask.cancel(false);
            this.scheduleDisconnect(0);
        }
    }

    private void scheduleDisconnect(int delay) {
        this.scheduledExecutorService.schedule(() -> {
            try {
                this.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, (long)delay, TimeUnit.SECONDS);
    }

    private void disconnect() throws ActiveMQException {
        if (this.clientConsumer != null) {
            this.clientConsumer.close();
            this.clientConsumer = null;
        }
        if (this.clientSession != null) {
            this.clientSession.close();
            this.clientSession = null;
        }
        if (this.clientSessionFactory != null && this.clientSessionFactory.numSessions() == 0 && !this.upstream.getConnection().isSharedConnection()) {
            this.clientSessionFactory.close();
            this.clientSessionFactory = null;
        }
    }

    public void onMessage(ClientMessage clientMessage) {
        block14: {
            try {
                int delta;
                ClientMessage message = clientMessage;
                if (message instanceof ClientLargeMessageInternal) {
                    StorageManager storageManager = this.server.getStorageManager();
                    LargeServerMessage lsm = storageManager.createCoreLargeMessage(storageManager.generateID(), (Message)message);
                    LargeMessageControllerImpl.LargeData largeData = null;
                    do {
                        largeData = ((ClientLargeMessageInternal)clientMessage).getLargeMessageController().take();
                        lsm.addBytes(largeData.getChunk());
                    } while (largeData.isContinues());
                    message = lsm.toMessage();
                    lsm.releaseResources(true, true);
                }
                if (this.server.hasBrokerFederationPlugins()) {
                    try {
                        this.server.callBrokerFederationPlugins(plugin -> plugin.beforeFederatedQueueConsumerMessageHandled(this, (Message)clientMessage));
                    }
                    catch (ActiveMQException t) {
                        ActiveMQServerLogger.LOGGER.federationPluginExecutionError("beforeFederatedQueueConsumerMessageHandled", t);
                        throw new IllegalStateException(t.getMessage(), t.getCause());
                    }
                }
                message = message.copy(this.server.getStorageManager().generateID());
                Object object = message = this.transformer == null ? message : this.transformer.transform((Message)message);
                if (message != null) {
                    this.server.getPostOffice().route((Message)message, true);
                }
                clientMessage.acknowledge();
                if (this.pendingPullCredit.get() > 0 && this.pendingPullCredit.addAndGet(-(delta = ((ClientMessageInternal)clientMessage).getFlowControlSize())) < 0) {
                    this.scheduleCreditOnEmpty(0, this.queueHandle);
                }
                if (!this.server.hasBrokerFederationPlugins()) break block14;
                try {
                    this.server.callBrokerFederationPlugins(plugin -> plugin.afterFederatedQueueConsumerMessageHandled(this, (Message)clientMessage));
                }
                catch (ActiveMQException t) {
                    ActiveMQServerLogger.LOGGER.federationPluginExecutionError("afterFederatedQueueConsumerMessageHandled", t);
                    throw new IllegalStateException(t.getMessage(), t.getCause());
                }
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.federationDispatchError(clientMessage.toString(), e);
                try {
                    ClientSession localSession = this.clientSession;
                    if (localSession != null) {
                        localSession.rollback();
                    }
                }
                catch (ActiveMQException activeMQException) {
                    // empty catch block
                }
            }
        }
    }

    public void connectionFailed(ActiveMQException exception, boolean failedOver) {
        this.connectionFailed(exception, failedOver, null);
    }

    public void connectionFailed(ActiveMQException exception, boolean failedOver, String scaleDownTargetNodeID) {
        try {
            this.clientSessionFactory.cleanup();
            this.clientSessionFactory.close();
            this.clientConsumer = null;
            this.clientSession = null;
            this.clientSessionFactory = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.scheduleConnect(0);
    }

    public void beforeReconnect(ActiveMQException exception) {
    }

    public ScheduledFuture getCurrentConnectTask() {
        return this.currentConnectTask;
    }

    public static interface ClientSessionCallback {
        public void callback(ClientSession var1) throws ActiveMQException;
    }

    static interface QueueHandle {
        public long getMessageCount();

        public int getCreditWindow();

        public Executor getExecutor();
    }
}

