/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.federation;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.FederationConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationDownstreamConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationPolicy;
import org.apache.activemq.artemis.core.config.federation.FederationUpstreamConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.federation.FederatedAbstract;
import org.apache.activemq.artemis.core.server.federation.FederationConnection;
import org.apache.activemq.artemis.core.server.federation.FederationDownstream;
import org.apache.activemq.artemis.core.server.federation.FederationManager;
import org.apache.activemq.artemis.core.server.federation.FederationUpstream;

public class Federation {
    private final ActiveMQServer server;
    private final SimpleString name;
    private final Map<String, FederationUpstream> upstreams = new HashMap<String, FederationUpstream>();
    private final Map<String, FederationDownstream> downstreams = new HashMap<String, FederationDownstream>();
    private final FederationConfiguration config;
    private FederationManager.State state;
    private final Map<String, FederationConnection> connections = new HashMap<String, FederationConnection>();

    public Federation(ActiveMQServer server, FederationConfiguration config) {
        this.server = server;
        this.config = config;
        Objects.requireNonNull(config.getName());
        this.name = SimpleString.of((String)config.getName());
    }

    public synchronized void start() throws ActiveMQException {
        if (this.state == FederationManager.State.STARTED) {
            return;
        }
        this.deploy();
        for (FederationUpstream federationUpstream : this.upstreams.values()) {
            federationUpstream.start();
        }
        for (FederationDownstream federationDownstream : this.downstreams.values()) {
            federationDownstream.start();
        }
        this.state = FederationManager.State.STARTED;
    }

    public synchronized void stop() {
        if (this.state == FederationManager.State.STOPPED) {
            return;
        }
        this.state = FederationManager.State.STOPPING;
        for (FederationUpstream federationUpstream : this.upstreams.values()) {
            federationUpstream.stop();
        }
        for (FederationDownstream federationDownstream : this.downstreams.values()) {
            federationDownstream.stop();
        }
        this.upstreams.clear();
        this.downstreams.clear();
        this.state = FederationManager.State.STOPPED;
    }

    public synchronized void deploy() throws ActiveMQException {
        for (FederationUpstreamConfiguration upstreamConfiguration : this.config.getUpstreamConfigurations()) {
            this.deploy(upstreamConfiguration, (Map<String, FederationPolicy>)this.config.getFederationPolicyMap());
        }
        for (FederationDownstreamConfiguration downstreamConfiguration : this.config.getDownstreamConfigurations()) {
            this.deploy(downstreamConfiguration, (Map<String, FederationPolicy>)this.config.getFederationPolicyMap());
        }
        if (this.state != FederationManager.State.STARTED) {
            this.state = FederationManager.State.DEPLOYED;
        }
    }

    public boolean isStarted() {
        return this.state == FederationManager.State.STARTED;
    }

    public synchronized boolean undeploy(String name) {
        FederationDownstream federationConnectionDownstream;
        FederationUpstream federationConnection = this.upstreams.remove(name);
        if (federationConnection != null) {
            federationConnection.stop();
        }
        if ((federationConnectionDownstream = this.downstreams.remove(name)) != null) {
            federationConnectionDownstream.undeploy();
            federationConnectionDownstream.stop();
        }
        return true;
    }

    public synchronized boolean deploy(FederationUpstreamConfiguration upstreamConfiguration, Map<String, FederationPolicy> federationPolicyMap) throws ActiveMQException {
        String name = upstreamConfiguration.getName();
        FederationUpstream upstream = this.upstreams.get(name);
        if (upstream == null) {
            this.undeploy(name);
            upstream = this.deploy(name, upstreamConfiguration);
        } else if (!upstream.getConnection().getConfig().equals((Object)upstreamConfiguration.getConnectionConfiguration())) {
            this.undeploy(name);
            upstream = this.deploy(name, upstreamConfiguration);
        }
        upstream.deploy(upstreamConfiguration.getPolicyRefs(), federationPolicyMap);
        return true;
    }

    private synchronized FederationUpstream deploy(String name, FederationUpstreamConfiguration upstreamConfiguration) {
        FederationUpstream upstream = new FederationUpstream(this.server, this, name, upstreamConfiguration);
        this.upstreams.put(name, upstream);
        if (this.state == FederationManager.State.STARTED) {
            upstream.start();
        }
        return upstream;
    }

    public synchronized boolean deploy(FederationDownstreamConfiguration downstreamConfiguration, Map<String, FederationPolicy> federationPolicyMap) throws ActiveMQException {
        String name = downstreamConfiguration.getName();
        FederationDownstream downstream = this.downstreams.get(name);
        if (downstream == null) {
            this.undeploy(name);
            downstream = this.deploy(name, downstreamConfiguration);
        } else if (!downstream.getConnection().getConfig().equals((Object)downstreamConfiguration.getConnectionConfiguration())) {
            this.undeploy(name);
            downstream = this.deploy(name, downstreamConfiguration);
        }
        downstream.deploy(this.config);
        return true;
    }

    private synchronized FederationDownstream deploy(String name, FederationDownstreamConfiguration downstreamConfiguration) {
        FederationConnection connection = null;
        if (downstreamConfiguration.getConnectionConfiguration().isShareConnection()) {
            for (FederationUpstream upstream : this.upstreams.values()) {
                if (!upstream.getConfig().getConnectionConfiguration().equals((Object)downstreamConfiguration.getConnectionConfiguration())) continue;
                connection = upstream.getConnection();
                connection.setSharedConnection(true);
                break;
            }
        }
        FederationDownstream downstream = new FederationDownstream(this.server, this, name, downstreamConfiguration, connection);
        this.downstreams.put(name, downstream);
        if (this.state == FederationManager.State.STARTED) {
            downstream.start();
        }
        return downstream;
    }

    public FederationUpstream get(String name) {
        return this.upstreams.get(name);
    }

    public FederationDownstream getDownstream(String name) {
        return this.downstreams.get(name);
    }

    public void register(FederatedAbstract federatedAbstract) {
        this.server.registerBrokerPlugin(federatedAbstract);
    }

    public void unregister(FederatedAbstract federatedAbstract) {
        this.server.unRegisterBrokerPlugin(federatedAbstract);
    }

    String getFederationPassword() {
        return this.config.getCredentials() == null ? null : this.config.getCredentials().getPassword();
    }

    String getFederationUser() {
        return this.config.getCredentials() == null ? null : this.config.getCredentials().getUser();
    }

    public FederationConfiguration getConfig() {
        return this.config;
    }

    public SimpleString getName() {
        return this.name;
    }

    static enum State {
        STOPPED,
        STOPPING,
        DEPLOYED,
        STARTED;

    }
}

