/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.function;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Function;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.cache.function.AbstractFunction;
import org.wildfly.clustering.cache.function.CollectionFunction;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class CollectionFunctionMarshaller<V, C extends Collection<V>, F extends CollectionFunction<V, C>>
implements ProtoStreamMarshaller<F> {
    private static final int ELEMENT_INDEX = 1;
    private final Class<? extends F> targetClass;
    private final Function<Collection<V>, F> factory;

    public CollectionFunctionMarshaller(Class<? extends F> targetClass, Function<Collection<V>, F> factory) {
        this.targetClass = targetClass;
        this.factory = factory;
    }

    public Class<? extends F> getJavaClass() {
        return this.targetClass;
    }

    public F readFrom(ProtoStreamReader reader) throws IOException {
        LinkedList<Object> operand = new LinkedList<Object>();
        block3: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    operand.add(reader.readAny());
                    continue block3;
                }
            }
            reader.skipField(tag);
        }
        return (F)((CollectionFunction)this.factory.apply(operand));
    }

    public void writeTo(ProtoStreamWriter writer, F function) throws IOException {
        for (Object value : (Collection)((AbstractFunction)function).getOperand()) {
            writer.writeAny(1, value);
        }
    }
}

