/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.client;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.impl.nio.DefaultNHttpClientConnection;
import org.apache.http.impl.nio.client.InternalRequestExecutor;
import org.apache.http.impl.nio.reactor.AbstractIODispatch;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpClientEventHandler;
import org.apache.http.nio.reactor.IOSession;

class InternalIODispatch
extends AbstractIODispatch<DefaultNHttpClientConnection> {
    private final Log log = LogFactory.getLog(InternalIODispatch.class);
    private final NHttpClientEventHandler handler;

    public InternalIODispatch(NHttpClientEventHandler handler) {
        this.handler = this.log.isDebugEnabled() ? new InternalRequestExecutor(this.log, handler) : handler;
    }

    protected DefaultNHttpClientConnection createConnection(IOSession session) {
        this.log.debug((Object)"Unexpected invocation of #createConnection");
        session.close();
        throw new CancelledKeyException();
    }

    protected void onConnected(DefaultNHttpClientConnection conn) {
        Object attachment = conn.getContext().getAttribute("http.session.attachment");
        try {
            this.handler.connected((NHttpClientConnection)conn, attachment);
        }
        catch (Exception ex) {
            this.handler.exception((NHttpClientConnection)conn, ex);
        }
    }

    protected void onClosed(DefaultNHttpClientConnection conn) {
        this.handler.closed((NHttpClientConnection)conn);
    }

    protected void onException(DefaultNHttpClientConnection conn, IOException ex) {
        this.handler.exception((NHttpClientConnection)conn, (Exception)ex);
    }

    protected void onInputReady(DefaultNHttpClientConnection conn) {
        conn.consumeInput(this.handler);
    }

    protected void onOutputReady(DefaultNHttpClientConnection conn) {
        conn.produceOutput(this.handler);
    }

    protected void onTimeout(DefaultNHttpClientConnection conn) {
        try {
            this.handler.timeout((NHttpClientConnection)conn);
        }
        catch (Exception ex) {
            this.handler.exception((NHttpClientConnection)conn, ex);
        }
    }
}

