/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.managedbean.processors;

import java.util.List;
import org.jboss.as.ee.managedbean.processors.ManagedBeanAnnotationProcessor;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;

public class ManagedBeanSubDeploymentMarkingProcessor
implements DeploymentUnitProcessor {
    private static final DotName MANAGED_BEAN = DotName.createSimple((String)"jakarta.annotation.ManagedBean");
    private static final boolean HAS_MANAGED_BEAN;

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        if (!HAS_MANAGED_BEAN) {
            return;
        }
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType(DeploymentType.EAR, deploymentUnit)) {
            return;
        }
        List potentialSubDeployments = deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS);
        for (ResourceRoot resourceRoot : potentialSubDeployments) {
            Index index;
            if (ModuleRootMarker.isModuleRoot((ResourceRoot)resourceRoot) || (index = (Index)resourceRoot.getAttachment(Attachments.ANNOTATION_INDEX)) == null || index.getAnnotations(MANAGED_BEAN).isEmpty()) continue;
            SubDeploymentMarker.mark((ResourceRoot)resourceRoot);
            ModuleRootMarker.mark((ResourceRoot)resourceRoot);
        }
    }

    static {
        boolean hasManagedBean = false;
        try {
            ManagedBeanAnnotationProcessor.class.getClassLoader().loadClass("jakarta.annotation.ManagedBean");
            hasManagedBean = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        HAS_MANAGED_BEAN = hasManagedBean;
    }
}

