/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.lra.coordinator;

import java.util.EnumSet;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.PersistentResourceXMLDescriptionReader;
import org.jboss.as.controller.PersistentResourceXMLDescriptionWriter;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.wildfly.extension.microprofile.lra.coordinator.MicroProfileLRACoordinatorSubsystemDefinition;
import org.wildfly.extension.microprofile.lra.coordinator.MicroProfileLRACoordinatorSubsystemModel;
import org.wildfly.extension.microprofile.lra.coordinator.MicroProfileLRACoordinatorSubsystemSchema;

public class MicroProfileLRACoordinatorExtension
implements Extension {
    static final String SUBSYSTEM_NAME = "microprofile-lra-coordinator";
    private static final MicroProfileLRACoordinatorSubsystemModel CURRENT_MODEL = MicroProfileLRACoordinatorSubsystemModel.VERSION_1_0_0;
    static final MicroProfileLRACoordinatorSubsystemSchema CURRENT_SCHEMA = MicroProfileLRACoordinatorSubsystemSchema.VERSION_1_0;
    private final PersistentResourceXMLDescription currentDescription = CURRENT_SCHEMA.getXMLDescription();

    public void initialize(ExtensionContext extensionContext) {
        SubsystemRegistration subsystem = extensionContext.registerSubsystem(SUBSYSTEM_NAME, CURRENT_MODEL.getVersion());
        subsystem.registerXMLElementWriter((XMLElementWriter)new PersistentResourceXMLDescriptionWriter(this.currentDescription));
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)new MicroProfileLRACoordinatorSubsystemDefinition());
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (MicroProfileLRACoordinatorSubsystemSchema schema : EnumSet.allOf(MicroProfileLRACoordinatorSubsystemSchema.class)) {
            MicroProfileLRACoordinatorSubsystemSchema reader = schema == CURRENT_SCHEMA ? new PersistentResourceXMLDescriptionReader(this.currentDescription) : schema;
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, schema.getNamespace().getUri(), (XMLElementReader)reader);
        }
    }
}

