/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.idle;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.connectionmanager.pool.idle.IdleConnectionRemovalSupport;
import org.jboss.jca.core.connectionmanager.pool.idle.SecurityActions;
import org.jboss.logging.Logger;

public class IdleRemover {
    private static CoreLogger logger = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)IdleRemover.class.getName());
    private static final String THREAD_NAME = "IdleRemover";
    private static IdleRemover instance = new IdleRemover();
    private CopyOnWriteArrayList<IdleConnectionRemovalSupport> registeredPools = new CopyOnWriteArrayList();
    private ExecutorService executorService = null;
    private boolean isExternal = false;
    private long interval = Long.MAX_VALUE;
    private long next = Long.MAX_VALUE;
    private AtomicBoolean shutdown = new AtomicBoolean(false);
    private Lock lock = new ReentrantLock(true);
    private Condition condition = this.lock.newCondition();

    private IdleRemover() {
    }

    public static IdleRemover getInstance() {
        return instance;
    }

    public void setExecutorService(ExecutorService v) {
        if (v != null) {
            this.executorService = v;
            this.isExternal = true;
        } else {
            this.executorService = null;
            this.isExternal = false;
        }
    }

    public void start() throws Throwable {
        if (!this.isExternal) {
            this.executorService = Executors.newSingleThreadExecutor(new IdleRemoverThreadFactory());
        }
        this.shutdown.set(false);
        this.interval = Long.MAX_VALUE;
        this.next = Long.MAX_VALUE;
        this.executorService.execute(new IdleRemoverRunner());
    }

    public void stop() throws Throwable {
        IdleRemover.instance.shutdown.set(true);
        if (!this.isExternal) {
            IdleRemover.instance.executorService.shutdownNow();
            IdleRemover.instance.executorService = null;
        }
        IdleRemover.instance.registeredPools.clear();
    }

    public void registerPool(IdleConnectionRemovalSupport mcp, long interval) {
        logger.debugf("Register pool: %s (interval=%s)", mcp, interval);
        instance.internalRegisterPool(mcp, interval);
    }

    public void unregisterPool(IdleConnectionRemovalSupport mcp) {
        logger.debugf("Unregister pool: %s", mcp);
        instance.internalUnregisterPool(mcp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRegisterPool(IdleConnectionRemovalSupport mcp, long interval) {
        try {
            this.lock.lock();
            this.registeredPools.addIfAbsent(mcp);
            if (interval > 1L && interval / 2L < this.interval) {
                this.interval = interval / 2L;
                long maybeNext = System.currentTimeMillis() + this.interval;
                if (this.next > maybeNext && maybeNext > 0L) {
                    this.next = maybeNext;
                    if (logger.isDebugEnabled()) {
                        logger.debug("About to notify thread: old next: " + this.next + ", new next: " + maybeNext);
                    }
                    this.condition.signal();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void internalUnregisterPool(IdleConnectionRemovalSupport mcp) {
        this.registeredPools.remove(mcp);
        if (this.registeredPools.size() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Setting interval to Long.MAX_VALUE");
            }
            this.interval = Long.MAX_VALUE;
        }
    }

    private static class IdleRemoverThreadFactory
    implements ThreadFactory {
        private IdleRemoverThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, IdleRemover.THREAD_NAME);
            thread.setDaemon(true);
            return thread;
        }
    }

    private class IdleRemoverRunner
    implements Runnable {
        private IdleRemoverRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClassLoader oldTccl = SecurityActions.getThreadContextClassLoader();
            SecurityActions.setThreadContextClassLoader(IdleRemover.class.getClassLoader());
            try {
                IdleRemover.this.lock.lock();
                while (!IdleRemover.this.shutdown.get()) {
                    boolean result = IdleRemover.instance.condition.await(IdleRemover.instance.interval, TimeUnit.MILLISECONDS);
                    if (logger.isTraceEnabled()) {
                        logger.trace("Result of await: " + result);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Notifying pools, interval: " + IdleRemover.this.interval);
                    }
                    for (IdleConnectionRemovalSupport mcp : IdleRemover.this.registeredPools) {
                        mcp.removeIdleConnections();
                    }
                    IdleRemover.this.next = System.currentTimeMillis() + IdleRemover.this.interval;
                    if (IdleRemover.this.next >= 0L) continue;
                    IdleRemover.this.next = Long.MAX_VALUE;
                }
            }
            catch (InterruptedException e) {
                if (!IdleRemover.this.shutdown.get()) {
                    logger.returningConnectionValidatorInterrupted();
                }
            }
            catch (RuntimeException e) {
                logger.connectionValidatorIgnoredUnexpectedRuntimeException(e);
            }
            catch (Exception e) {
                logger.connectionValidatorIgnoredUnexpectedError(e);
            }
            finally {
                IdleRemover.this.lock.unlock();
                SecurityActions.setThreadContextClassLoader(oldTccl);
            }
        }
    }
}

