/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.security.PrivilegedAction;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import org.wildfly.clustering.context.ContextualExecutorService;
import org.wildfly.clustering.context.DefaultContextualizerFactory;
import org.wildfly.clustering.context.DefaultThreadFactory;
import org.wildfly.clustering.context.Reflect;

public class DefaultExecutorService
extends ContextualExecutorService {
    public static final PrivilegedAction<Void> shutdown(final ExecutorService executor) {
        return new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                executor.shutdown();
                return null;
            }
        };
    }

    public static final PrivilegedAction<List<Runnable>> shutdownNow(final ExecutorService executor) {
        return new PrivilegedAction<List<Runnable>>(){

            @Override
            public List<Runnable> run() {
                return executor.shutdownNow();
            }
        };
    }

    public DefaultExecutorService(Function<ThreadFactory, ExecutorService> factory, ClassLoader loader) {
        super(factory.apply(new DefaultThreadFactory(Thread.currentThread()::getThreadGroup, Reflect.getClassLoader(DefaultExecutorService.class))), DefaultContextualizerFactory.INSTANCE.createContextualizer(loader));
    }
}

