/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ServiceLoader;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.threads.JBossThreadFactory;

class Reflect {
    Reflect() {
    }

    static ClassLoader getClassLoader(final Class<?> targetClass) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return targetClass.getClassLoader();
            }
        });
    }

    static ThreadFactory createThreadFactory(final Supplier<ThreadGroup> group) {
        return AccessController.doPrivileged(new PrivilegedAction<ThreadFactory>(){

            @Override
            public ThreadFactory run() {
                return new JBossThreadFactory((ThreadGroup)group.get(), Boolean.FALSE, null, "%G - %t", null, null);
            }
        });
    }

    static ClassLoader getContextClassLoader(final Thread thread) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return thread.getContextClassLoader();
            }
        });
    }

    static ClassLoader setContextClassLoader(final Thread thread, final ClassLoader loader) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader current = thread.getContextClassLoader();
                thread.setContextClassLoader(loader);
                return current;
            }
        });
    }

    static <T> void load(final Class<T> targetClass, final Consumer<T> consumer) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Void run() {
                for (Object provider : ServiceLoader.load(targetClass, targetClass.getClassLoader())) {
                    consumer.accept(provider);
                }
                return null;
            }
        });
    }
}

