/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.security.manager;

import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.security.FactoryPermissionCollection;
import org.jboss.modules.security.PermissionFactory;
import org.wildfly.extension.security.manager.DeferredPermissionFactory;
import org.wildfly.extension.security.manager.DeploymentPermissionsResourceDefinition;
import org.wildfly.extension.security.manager.deployment.PermissionsParserProcessor;
import org.wildfly.extension.security.manager.deployment.PermissionsValidationProcessor;
import org.wildfly.extension.security.manager.logging.SecurityManagerLogger;

class SecurityManagerSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    static final SecurityManagerSubsystemAdd INSTANCE = new SecurityManagerSubsystemAdd();

    private SecurityManagerSubsystemAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        ModelNode node = Resource.Tools.readModel((Resource)resource);
        ModelNode deploymentPermissionsModel = node.get(DeploymentPermissionsResourceDefinition.DEPLOYMENT_PERMISSIONS_PATH.getKeyValuePair());
        ModelNode minimumPermissionsNode = DeploymentPermissionsResourceDefinition.MINIMUM_PERMISSIONS.resolveModelAttribute(context, deploymentPermissionsModel);
        final List<PermissionFactory> minimumSet = this.retrievePermissionSet(DeferredPermissionFactory.Type.MINIMUM_SET, context, minimumPermissionsNode);
        ModelNode maximumPermissionsNode = DeploymentPermissionsResourceDefinition.MAXIMUM_PERMISSIONS.resolveModelAttribute(context, deploymentPermissionsModel);
        if (!maximumPermissionsNode.isDefined()) {
            maximumPermissionsNode = DeploymentPermissionsResourceDefinition.DEFAULT_MAXIMUM_SET;
        }
        final List<PermissionFactory> maximumSet = this.retrievePermissionSet(DeferredPermissionFactory.Type.MAXIMUM_SET, context, maximumPermissionsNode);
        FactoryPermissionCollection maxPermissionCollection = new FactoryPermissionCollection(maximumSet.toArray(new PermissionFactory[maximumSet.size()]));
        StringBuilder failedPermissions = new StringBuilder();
        for (PermissionFactory factory : minimumSet) {
            Permission permission = factory.construct();
            if (permission == null || maxPermissionCollection.implies(permission)) continue;
            failedPermissions.append("\n\t\t").append(permission);
        }
        if (failedPermissions.length() > 0) {
            throw SecurityManagerLogger.ROOT_LOGGER.invalidSubsystemConfiguration(failedPermissions);
        }
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("security-manager", Phase.PARSE, 12544, (DeploymentUnitProcessor)new PermissionsParserProcessor(minimumSet));
                processorTarget.addDeploymentProcessor("security-manager", Phase.POST_MODULE, 14080, (DeploymentUnitProcessor)new PermissionsValidationProcessor(maximumSet));
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private List<PermissionFactory> retrievePermissionSet(DeferredPermissionFactory.Type type, OperationContext context, ModelNode node) throws OperationFailedException {
        ArrayList<PermissionFactory> permissions = new ArrayList<PermissionFactory>();
        if (node != null && node.isDefined()) {
            for (ModelNode permissionNode : node.asList()) {
                String permissionClass = DeploymentPermissionsResourceDefinition.CLASS.resolveModelAttribute(context, permissionNode).asString();
                String permissionName = null;
                if (permissionNode.hasDefined("name")) {
                    permissionName = DeploymentPermissionsResourceDefinition.NAME.resolveModelAttribute(context, permissionNode).asString();
                }
                String permissionActions = null;
                if (permissionNode.hasDefined("actions")) {
                    permissionActions = DeploymentPermissionsResourceDefinition.ACTIONS.resolveModelAttribute(context, permissionNode).asString();
                }
                String moduleName = null;
                if (permissionNode.hasDefined("module")) {
                    moduleName = DeploymentPermissionsResourceDefinition.MODULE.resolveModelAttribute(context, permissionNode).asString();
                }
                permissions.add(new DeferredPermissionFactory(type, Module.getBootModuleLoader(), moduleName, permissionClass, permissionName, permissionActions));
            }
        }
        return permissions;
    }
}

