/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages;

import org.apache.activemq.artemis.cli.Shell;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.InputAbstract;
import picocli.CommandLine;

public class ConnectionConfigurationAbtract
extends InputAbstract {
    @CommandLine.Option(names={"--url"}, description={"Connection URL. Default: build URL from the 'artemis' acceptor defined in the broker.xml or tcp://localhost:61616 if the acceptor cannot be parsed."})
    protected String brokerURL = "tcp://localhost:61616";
    @CommandLine.Option(names={"--acceptor"}, description={"Name used to find the default connection URL on the acceptor list. If an acceptor with that name cannot be found the CLI will look for a connector with the same name."})
    protected String acceptor;
    @CommandLine.Option(names={"--user"}, description={"User used to connect."})
    protected String user;
    @CommandLine.Option(names={"--password"}, description={"Password used to connect."})
    protected String password;
    protected boolean silent = false;
    protected static ThreadLocal<ConnectionInformation> CONNECTION_INFORMATION = new ThreadLocal();

    public String getBrokerURL() {
        return this.brokerURL;
    }

    public void setBrokerURL(String brokerURL) {
        this.brokerURL = brokerURL;
    }

    public String getAcceptor() {
        return this.acceptor;
    }

    public ConnectionConfigurationAbtract setAcceptor(String acceptor) {
        this.acceptor = acceptor;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public ConnectionConfigurationAbtract setUser(String user) {
        this.user = user;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public ConnectionConfigurationAbtract setPassword(String password) {
        this.password = password;
        return this;
    }

    @Override
    public Object execute(ActionContext context) throws Exception {
        String brokerURLInstance;
        super.execute(context);
        this.recoverConnectionInformation();
        if (this.brokerURL == "tcp://localhost:61616" && (brokerURLInstance = this.getBrokerURLInstance(this.acceptor)) != null) {
            this.brokerURL = brokerURLInstance;
        }
        if (!this.silent) {
            context.out.println("Connection brokerURL = " + this.brokerURL);
        }
        return null;
    }

    protected void recoverConnectionInformation() {
        if (CONNECTION_INFORMATION.get() != null) {
            ConnectionInformation connectionInfo = CONNECTION_INFORMATION.get();
            if (this.user == null) {
                this.user = connectionInfo.user;
            }
            if (this.password == null) {
                this.password = connectionInfo.password;
            }
            if (this.brokerURL == null || this.brokerURL == "tcp://localhost:61616") {
                this.brokerURL = connectionInfo.uri;
            }
        }
    }

    protected void saveConnectionInfo(String brokerURL, String user, String password) {
        if (Shell.inShell() && CONNECTION_INFORMATION.get() == null) {
            CONNECTION_INFORMATION.set(new ConnectionInformation(brokerURL, user, password));
            this.getActionContext().out.println("CLI connected to broker " + brokerURL + ", user:" + user);
            this.brokerURL = brokerURL;
            this.user = user;
            this.password = password;
        }
    }

    protected String inputBrokerURL(String defaultValue) {
        return this.input("--url", "Type in the connection URL for a retry (e.g. tcp://localhost:61616)", defaultValue);
    }

    protected String inputUser(String user) {
        if (user == null) {
            this.user = this.input("--user", "Type the username for a retry", null);
            return this.user;
        }
        return user;
    }

    protected String inputPassword(String password) {
        if (password == null) {
            this.password = this.inputPassword("--password", "Type the password for a retry", null);
            return this.password;
        }
        return password;
    }

    static class ConnectionInformation {
        String uri;
        String user;
        String password;

        private ConnectionInformation(String uri, String user, String password) {
            this.uri = uri;
            this.user = user;
            this.password = password;
        }
    }
}

