/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.queue;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.api.core.management.SimpleManagement;
import org.apache.activemq.artemis.cli.Terminal;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.messages.ConnectionAbstract;
import org.apache.activemq.artemis.json.JsonArray;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.utils.TableOut;
import picocli.CommandLine;

@CommandLine.Command(name="stat", description={"Print basic stats of a queue. Output includes CONSUMER_COUNT (number of consumers), MESSAGE_COUNT (current message count on the queue, including scheduled, paged and in-delivery messages), MESSAGES_ADDED (messages added to the queue), DELIVERING_COUNT (messages broker is currently delivering to consumer(s)), MESSAGES_ACKED (messages acknowledged from the consumer(s)). Queues can be filtered using EITHER '--queueName X' where X is contained in the queue name OR using a full filter '--field NAME --operation EQUALS --value X'."})
public class StatQueue
extends ConnectionAbstract {
    private static final String NOT_APPLICABLE = "";
    private static final String MANAGEMENT_QUEUE = "activemq.management";
    public static final int DEFAULT_MAX_ROWS = 50;
    public static final int DEFAULT_MAX_COLUMN_SIZE = 25;
    @CommandLine.Option(names={"--queueName"}, description={"Display queue stats for queue(s) with names containing this string."})
    private String queueName;
    @CommandLine.Option(names={"--field"}, description={"The field to filter. Possible values: NAME, ADDRESS, MESSAGE_COUNT, MESSAGES_ADDED, DELIVERING_COUNT, MESSAGES_ACKED, SCHEDULED_COUNT, ROUTING_TYPE."})
    private String fieldName;
    @CommandLine.Option(names={"--operation"}, description={"The operation to filter. Possible values: CONTAINS, NOT_CONTAINS, EQUALS, GREATER_THAN, LESS_THAN."})
    private String operationName;
    @CommandLine.Option(names={"--value"}, description={"The value to filter."})
    private String value;
    @CommandLine.Option(names={"--maxRows"}, description={"The max number of queues displayed. Default is 50."})
    private int maxRows = 50;
    @CommandLine.Option(names={"--maxColumnSize"}, description={"The max width of data column. Set to -1 for no limit. Default is 25."})
    private int maxColumnSize = 25;
    @CommandLine.Option(names={"--clustered"}, description={"Expands the report for all nodes on the topology"})
    private boolean clustered = false;
    @CommandLine.Option(names={"--include-management"}, description={"Include queues created for notification management in the output"})
    private boolean includeManagement = false;
    @CommandLine.Option(names={"--loop"}, description={"Keep Queue Stat in a forever loop, that you can interrupt with Ctrl-C, sleeping for --loop-time between each iteration."})
    private boolean useLoop = false;
    private static final long DEFAULT_SLEEP = 60000L;
    @CommandLine.Option(names={"--loop-sleep"}, description={"Amount of Milliseconds to sleep before each iteration on queue stat. Default=60000"}, hidden=true)
    private long oldSleep = -1L;
    @CommandLine.Option(names={"--sleep"}, description={"Amount of Milliseconds to sleep before each iteration on queue stat. Default=60000"})
    private long loopSleep = -1L;
    @CommandLine.Option(names={"--single-line-header"}, description={"Use a single line on the header titles"})
    private boolean singleLineHeader = false;
    @CommandLine.Option(names={"--json"}, description={"Prints the queue stat information in JSON format, useful for scripts"})
    private boolean json;
    private int statCount = 0;

    public boolean isSingleLineHeader() {
        return this.singleLineHeader;
    }

    public StatQueue setSingleLineHeader(boolean singleLineHeader) {
        this.singleLineHeader = singleLineHeader;
        return this;
    }

    public StatQueue setQueueName(String queueName) {
        this.queueName = queueName;
        return this;
    }

    public StatQueue setOperationName(String operationName) {
        this.operationName = operationName;
        return this;
    }

    public StatQueue setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public StatQueue setValue(String value) {
        this.value = value;
        return this;
    }

    public StatQueue setMaxRows(int maxRows) {
        this.maxRows = maxRows;
        return this;
    }

    public StatQueue setMaxColumnSize(int maxColumnSize) {
        int maxFieldSize = 0;
        for (FIELD e : FIELD.values()) {
            if (e.jsonId.length() <= maxFieldSize) continue;
            maxFieldSize = e.jsonId.length();
        }
        if (maxColumnSize != -1 && maxColumnSize < maxFieldSize) {
            throw new IllegalArgumentException("maxColumnSize must be " + maxFieldSize + " or greater or -1 (i.e. no limit).");
        }
        this.maxColumnSize = maxColumnSize;
        return this;
    }

    public StatQueue setverbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public boolean isJson() {
        return this.json;
    }

    public StatQueue setJson(boolean json) {
        this.json = json;
        return this;
    }

    @Override
    public Object execute(ActionContext context) throws Exception {
        if (this.json) {
            this.silent = true;
        }
        super.execute(context);
        String filter = this.createFilter();
        if (filter == null) {
            return null;
        }
        if (this.verbose) {
            this.getActionContext().out.println("filter is '" + filter + "'");
            this.getActionContext().out.println("maxRows='" + this.maxRows + "'");
        }
        this.createConnectionFactory();
        if (this.json) {
            this.jsonExecution(context, filter);
            return 1;
        }
        this.singleExeuction(context, filter);
        if (this.oldSleep != -1L) {
            this.loopSleep = this.oldSleep;
        }
        if (this.loopSleep != -1L) {
            this.useLoop = true;
        }
        if (this.useLoop && this.loopSleep == -1L) {
            this.loopSleep = 60000L;
        }
        while (this.useLoop) {
            this.getActionContext().out.println("Waiting " + this.loopSleep + " before another queue stat iteration");
            Thread.sleep(this.loopSleep);
            this.getActionContext().out.println(new Date() + ">> Queue stat results for " + this.getBrokerInstance());
            try {
                this.singleExeuction(context, filter);
            }
            catch (Throwable e) {
                e.printStackTrace(this.getActionContext().err);
            }
        }
        return this.statCount;
    }

    private void jsonExecution(ActionContext context, String filter) throws Exception {
        this.performCoreManagement(this.brokerURL, this.user, this.password, message -> ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"listQueues", (Object[])new Object[]{filter, 1, this.maxRows}), reply -> {
            String result = (String)ManagementHelper.getResult((ICoreMessage)reply, String.class);
            result = result.replace("{\"id\"", "\n   {\"id\"");
            result = result.replace("]", "\n]");
            context.out.println(result);
        }, reply -> {
            String errMsg = (String)ManagementHelper.getResult((ICoreMessage)reply, String.class);
            this.getActionContext().err.println("Failed to get Stats for Queues. Reason: " + errMsg);
        });
    }

    private void singleExeuction(ActionContext context, String filter) throws Exception {
        try (SimpleManagement simpleManagement = new SimpleManagement(this.brokerURL, this.user, this.password).open();){
            String nodeID = simpleManagement.getNodeID();
            JsonArray topology = simpleManagement.listNetworkTopology();
            if (this.clustered && topology.size() > 1) {
                context.out.println(Terminal.YELLOW_UNICODE + "*******************************************************************************************************************************");
                context.out.println(">>> Queue stats on node " + nodeID + ", url=" + this.brokerURL + Terminal.CLEAR_UNICODE);
                this.printStats(this.brokerURL, filter);
                for (int i = 0; i < topology.size(); ++i) {
                    JsonObject node = topology.getJsonObject(i);
                    if (node.getString("nodeID").equals(nodeID) || node.getJsonString("live") == null) continue;
                    String url = "tcp://" + node.getString("live");
                    context.out.println(Terminal.YELLOW_UNICODE + "*******************************************************************************************************************************");
                    context.out.println(">>> Queue stats on node " + node.getString("nodeID") + ", url=" + url + Terminal.CLEAR_UNICODE);
                    this.printStats(url, filter);
                }
            } else {
                this.printStats(this.brokerURL, filter);
                if (topology.size() > 1) {
                    context.out.println();
                    context.out.println("Note: Use " + Terminal.RED_UNICODE + "--clustered" + Terminal.CLEAR_UNICODE + " to expand the report to other nodes in the topology.");
                    context.out.println();
                }
            }
        }
    }

    private void printStats(String uri, String filter) throws Exception {
        this.performCoreManagement(uri, this.user, this.password, message -> ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"listQueues", (Object[])new Object[]{filter, 1, this.maxRows}), reply -> {
            String result = (String)ManagementHelper.getResult((ICoreMessage)reply, String.class);
            this.printStats(result);
        }, reply -> {
            String errMsg = (String)ManagementHelper.getResult((ICoreMessage)reply, String.class);
            this.getActionContext().err.println("Failed to get Stats for Queues. Reason: " + errMsg);
        });
    }

    private void printStats(String result) {
        int i;
        if (result == null) {
            if (this.verbose) {
                this.getActionContext().err.println("printStats(): got NULL result string.");
            }
            return;
        }
        JsonObject queuesAsJsonObject = JsonUtil.readJsonObject((String)result);
        int count = queuesAsJsonObject.getInt("count");
        JsonArray array = queuesAsJsonObject.getJsonArray("data");
        int[] columnSizes = new int[FIELD.values().length];
        boolean[] centralize = new boolean[columnSizes.length];
        ArrayList[] fieldTitles = new ArrayList[columnSizes.length];
        FIELD[] fields = FIELD.values();
        for (i = 0; i < fields.length; ++i) {
            if (this.singleLineHeader) {
                columnSizes[i] = fields[i].toString().length();
                continue;
            }
            ArrayList<String> splitTitleArrayList = new ArrayList<String>();
            String[] splitTitleStringArray = fields[i].toString().split("_");
            centralize[i] = fields[i].center;
            for (String s : splitTitleStringArray) {
                splitTitleArrayList.add(s);
                columnSizes[i] = Math.max(columnSizes[i], s.length());
            }
            fieldTitles[i] = splitTitleArrayList;
        }
        for (i = 0; i < array.size(); ++i) {
            this.getColumnSizes(array.getJsonObject(i), columnSizes);
        }
        TableOut tableOut = new TableOut("|", 2, columnSizes);
        if (this.singleLineHeader) {
            this.printHeadings(columnSizes);
        } else {
            tableOut.print(this.getActionContext().out, fieldTitles, centralize);
        }
        for (int i2 = 0; i2 < array.size(); ++i2) {
            if (!this.includeManagement && array.getJsonObject(i2).getString("name").contains(MANAGEMENT_QUEUE)) continue;
            this.printQueueStats(array.getJsonObject(i2), columnSizes, centralize, tableOut);
            ++this.statCount;
        }
        if (count > this.maxRows) {
            this.getActionContext().out.println(String.format("WARNING: the displayed queues are %d/%d, set maxRows to display more queues.", this.maxRows, count));
        }
    }

    private void getColumnSizes(JsonObject jsonObject, int[] columnSizes) {
        int i = 0;
        if (!this.includeManagement && jsonObject.getString("name").startsWith(MANAGEMENT_QUEUE)) {
            return;
        }
        for (FIELD e : FIELD.values()) {
            if (jsonObject.containsKey((Object)e.jsonId)) {
                if (jsonObject.getString(e.jsonId).length() > columnSizes[i]) {
                    columnSizes[i] = jsonObject.getString(e.jsonId).length();
                }
            } else if (NOT_APPLICABLE.length() > columnSizes[i]) {
                columnSizes[i] = NOT_APPLICABLE.length();
            }
            if (columnSizes[i] > this.maxColumnSize && this.maxColumnSize != -1) {
                columnSizes[i] = this.maxColumnSize;
            }
            ++i;
        }
    }

    private void printHeadings(int[] columnSizes) {
        StringBuilder stringBuilder = new StringBuilder(Arrays.stream(columnSizes).sum() + FIELD.values().length + 1).append('|');
        int i = 0;
        for (FIELD e : FIELD.values()) {
            stringBuilder.append((CharSequence)this.paddingString(new StringBuilder(e.toString()), columnSizes[i++])).append('|');
        }
        this.getActionContext().out.println(stringBuilder);
    }

    private void printQueueStats(JsonObject jsonObject, int[] columnSizes, boolean[] center, TableOut tableOut) {
        if (jsonObject == null) {
            if (this.verbose) {
                this.getActionContext().err.println("printQueueStats(): jsonObject is null");
            }
            return;
        }
        int i = 0;
        String[] columns = new String[columnSizes.length];
        for (FIELD e : FIELD.values()) {
            columns[i++] = !jsonObject.containsKey((Object)e.jsonId) ? NOT_APPLICABLE : jsonObject.getString(e.jsonId);
        }
        tableOut.print(this.getActionContext().out, columns, center);
    }

    private StringBuilder paddingString(StringBuilder value, int maxColumnSize) {
        int length;
        if (value == null) {
            return new StringBuilder(maxColumnSize);
        }
        if (value.length() == 0) {
            value.append("NO DATA");
        }
        if ((length = value.length()) > maxColumnSize && this.maxColumnSize != -1) {
            return new StringBuilder(value.substring(0, maxColumnSize - 3) + "...");
        }
        int i = 1;
        while (i + length <= maxColumnSize) {
            value.append(' ');
            ++i;
        }
        return value;
    }

    private String createFilter() {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        if (this.fieldName != null && this.fieldName.trim().length() > 0 && this.queueName != null && this.queueName.trim().length() > 0) {
            this.getActionContext().err.println("'--field' and '--queueName' cannot be specified together.");
            return null;
        }
        if (this.fieldName != null && this.fieldName.trim().length() > 0) {
            try {
                FIELD field = FIELD.valueOfJsonId(this.fieldName);
                if (field == null) {
                    field = FIELD.valueOf(this.fieldName);
                }
                filterMap.put("field", field.toString());
            }
            catch (IllegalArgumentException ex) {
                this.getActionContext().err.println("'--field' must be set to one of the following " + Arrays.toString((Object[])FIELD.values()));
                return null;
            }
            if (this.value == null || this.value.trim().length() == 0) {
                this.getActionContext().err.println("'--value' needs to be set when '--field' is specified");
                return null;
            }
            filterMap.put("value", this.value);
            if (this.operationName == null) {
                this.getActionContext().err.println("'--operation' must be set when '--field' is specified " + Arrays.toString((Object[])OPERATION.values()));
                return null;
            }
            try {
                OPERATION operation = OPERATION.valueOf(this.operationName);
                filterMap.put("operation", operation.toString());
            }
            catch (IllegalArgumentException ex) {
                this.getActionContext().err.println("'--operation' must be set to one of the following " + Arrays.toString((Object[])OPERATION.values()));
                return null;
            }
        }
        if (this.queueName != null && this.queueName.trim().length() > 0) {
            filterMap.put("field", FIELD.NAME.toString());
            filterMap.put("value", this.queueName);
            filterMap.put("operation", OPERATION.CONTAINS.toString());
        } else {
            filterMap.put("field", NOT_APPLICABLE);
            filterMap.put("value", NOT_APPLICABLE);
            filterMap.put("operation", NOT_APPLICABLE);
        }
        JsonObject filterJsonObject = JsonUtil.toJsonObject(filterMap);
        return filterJsonObject.toString();
    }

    public static enum OPERATION {
        CONTAINS,
        NOT_CONTAINS,
        EQUALS,
        GREATER_THAN,
        LESS_THAN;

    }

    public static enum FIELD {
        NAME("name", false),
        ADDRESS("address", false),
        CONSUMER_COUNT("consumerCount", true),
        MESSAGE_COUNT("messageCount", true),
        MESSAGES_ADDED("messagesAdded", true),
        DELIVERING_COUNT("deliveringCount", true),
        MESSAGES_ACKED("messagesAcked", true),
        SCHEDULED_COUNT("scheduledCount", true),
        ROUTING_TYPE("routingType", true),
        INTERNAL("internalQueue", true);

        private static final Map<String, FIELD> lookup;
        private String jsonId;
        private boolean center;

        private FIELD(String jsonId, boolean center) {
            this.jsonId = jsonId;
            this.center = center;
        }

        String getJsonId() {
            return this.jsonId;
        }

        public static FIELD valueOfJsonId(String jsonId) {
            return lookup.get(jsonId);
        }

        static {
            lookup = new TreeMap<String, FIELD>(String.CASE_INSENSITIVE_ORDER);
            for (FIELD e : FIELD.values()) {
                lookup.put(e.jsonId, e);
            }
        }
    }
}

