/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.event.impl;

import java.util.Optional;
import org.hibernate.query.Query;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxEventPredicate;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.data.RangeBoundInclusion;

public final class EntityIdHashRangeOutboxEventPredicate
implements OutboxEventPredicate {
    private static final String LOWER_BOUND_PARAM_NAME = "lowerHash";
    private static final String UPPER_BOUND_PARAM_NAME = "upperHash";
    private final Integer lowerBoundIncluded;
    private final Integer upperBoundIncluded;

    public EntityIdHashRangeOutboxEventPredicate(Range<Integer> range) {
        Optional lowerBound = range.lowerBoundValue();
        if (lowerBound.isPresent()) {
            Integer lowerBoundValue = (Integer)lowerBound.get();
            if (range.lowerBoundInclusion() == RangeBoundInclusion.EXCLUDED) {
                lowerBoundValue = lowerBoundValue + 1;
            }
            this.lowerBoundIncluded = lowerBoundValue;
        } else {
            this.lowerBoundIncluded = null;
        }
        Optional upperBound = range.upperBoundValue();
        if (upperBound.isPresent()) {
            Integer upperBoundValue = (Integer)upperBound.get();
            if (range.upperBoundInclusion() == RangeBoundInclusion.EXCLUDED) {
                upperBoundValue = upperBoundValue - 1;
            }
            this.upperBoundIncluded = upperBoundValue;
        } else {
            this.upperBoundIncluded = null;
        }
    }

    @Override
    public String queryPart(String eventAlias) {
        StringBuilder builder = new StringBuilder(eventAlias);
        builder.append(".entityIdHash ");
        if (this.lowerBoundIncluded != null && this.upperBoundIncluded != null) {
            builder.append("between :").append(LOWER_BOUND_PARAM_NAME).append(" and :").append(UPPER_BOUND_PARAM_NAME);
        } else if (this.lowerBoundIncluded != null) {
            builder.append(" >= :").append(LOWER_BOUND_PARAM_NAME);
        } else if (this.upperBoundIncluded != null) {
            builder.append(" <= :").append(UPPER_BOUND_PARAM_NAME);
        }
        return builder.toString();
    }

    @Override
    public void setParams(Query<?> query) {
        if (this.lowerBoundIncluded != null) {
            query.setParameter(LOWER_BOUND_PARAM_NAME, (Object)this.lowerBoundIncluded);
        }
        if (this.upperBoundIncluded != null) {
            query.setParameter(UPPER_BOUND_PARAM_NAME, (Object)this.upperBoundIncluded);
        }
    }
}

