/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.event.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Optional;
import org.hibernate.boot.jaxb.mapping.JaxbEntityMappings;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.mapper.orm.bootstrap.spi.HibernateSearchOrmMappingProducer;
import org.hibernate.search.mapper.orm.outboxpolling.cfg.HibernateOrmMapperOutboxPollingSettings;
import org.hibernate.search.mapper.orm.outboxpolling.cfg.UuidGenerationStrategy;
import org.hibernate.search.mapper.orm.outboxpolling.cfg.impl.UuidDataTypeUtils;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxEvent;
import org.hibernate.search.mapper.orm.outboxpolling.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.outboxpolling.logging.impl.Log;
import org.hibernate.search.mapper.orm.outboxpolling.mapping.impl.AdditionalMappingBuilder;
import org.hibernate.search.mapper.orm.outboxpolling.mapping.impl.JaxbMappingHelper;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class OutboxPollingOutboxEventAdditionalJaxbMappingProducer
implements HibernateSearchOrmMappingProducer {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final String CLASS_NAME;
    public static final String ENTITY_NAME;
    public static final String ENTITY_DEFINITION;
    private static final OptionalConfigurationProperty<String> OUTBOXEVENT_ENTITY_MAPPING;
    private static final OptionalConfigurationProperty<String> ENTITY_MAPPING_OUTBOXEVENT_SCHEMA;
    private static final OptionalConfigurationProperty<String> ENTITY_MAPPING_OUTBOXEVENT_CATALOG;
    private static final OptionalConfigurationProperty<String> ENTITY_MAPPING_OUTBOXEVENT_TABLE;
    public static final OptionalConfigurationProperty<UuidGenerationStrategy> ENTITY_MAPPING_OUTBOXEVENT_UUID_GEN_STRATEGY;
    private static final OptionalConfigurationProperty<String> ENTITY_MAPPING_OUTBOXEVENT_UUID_TYPE;

    public Map<Class<?>, JaxbEntityMappings> produceMappings(ConfigurationPropertySource propertySource, MetadataBuildingContext buildingContext) {
        JaxbEntityMappings mappings;
        Optional mapping = (Optional)OUTBOXEVENT_ENTITY_MAPPING.get(propertySource);
        Optional schema = (Optional)ENTITY_MAPPING_OUTBOXEVENT_SCHEMA.get(propertySource);
        Optional catalog = (Optional)ENTITY_MAPPING_OUTBOXEVENT_CATALOG.get(propertySource);
        Optional table = (Optional)ENTITY_MAPPING_OUTBOXEVENT_TABLE.get(propertySource);
        Optional uuidStrategy = (Optional)ENTITY_MAPPING_OUTBOXEVENT_UUID_GEN_STRATEGY.get(propertySource);
        Optional uuidType = ENTITY_MAPPING_OUTBOXEVENT_UUID_TYPE.getAndMap(propertySource, value -> UuidDataTypeUtils.uuidType(value, propertySource, ENTITY_MAPPING_OUTBOXEVENT_UUID_TYPE));
        if (mapping.isPresent() && (schema.isPresent() || catalog.isPresent() || table.isPresent() || uuidStrategy.isPresent() || uuidType.isPresent())) {
            throw log.outboxEventConfigurationPropertyConflict(OUTBOXEVENT_ENTITY_MAPPING.resolveOrRaw(propertySource), new String[]{ENTITY_MAPPING_OUTBOXEVENT_SCHEMA.resolveOrRaw(propertySource), ENTITY_MAPPING_OUTBOXEVENT_CATALOG.resolveOrRaw(propertySource), ENTITY_MAPPING_OUTBOXEVENT_TABLE.resolveOrRaw(propertySource), ENTITY_MAPPING_OUTBOXEVENT_UUID_GEN_STRATEGY.resolveOrRaw(propertySource), ENTITY_MAPPING_OUTBOXEVENT_UUID_TYPE.resolveOrRaw(propertySource)});
        }
        if (mapping.isPresent()) {
            mappings = JaxbMappingHelper.unmarshall((String)mapping.get());
        } else {
            Integer resolvedUuidType = uuidType.orElse(null);
            String resolvedUuidStrategy = uuidStrategy.orElse(HibernateOrmMapperOutboxPollingSettings.Defaults.COORDINATION_ENTITY_MAPPING_OUTBOX_EVENT_UUID_GEN_STRATEGY).strategy();
            mappings = OutboxPollingOutboxEventAdditionalJaxbMappingProducer.createMappings(schema.orElse(""), catalog.orElse(""), table.orElse("HSEARCH_OUTBOX_EVENT"), resolvedUuidType, resolvedUuidStrategy, HibernateOrmUtils.isDiscriminatorMultiTenancyEnabled(buildingContext));
        }
        log.outboxEventGeneratedEntityMapping(mappings);
        return Map.of(OutboxEvent.class, mappings);
    }

    private static JaxbEntityMappings createMappings(String schema, String catalog, String table, Integer resolvedUuidType, String resolvedUuidStrategy, boolean tenantIdRequired) {
        AdditionalMappingBuilder builder = new AdditionalMappingBuilder(OutboxEvent.class, ENTITY_NAME).id(resolvedUuidType, resolvedUuidStrategy).index("entityIdHash").index("status").index("processAfter").table(schema, catalog, table).attribute("entityName", 256, false).attribute("entityId", 256, false).attribute("entityIdHash", null, false).attribute("payload", Integer.MAX_VALUE, false).attribute("retries", null, false).attribute("processAfter", null, false).enumAttribute("status", null, false);
        if (tenantIdRequired) {
            builder.tenantId("tenantId");
        }
        return builder.build();
    }

    static {
        ENTITY_NAME = CLASS_NAME = OutboxEvent.class.getName();
        ENTITY_DEFINITION = JaxbMappingHelper.marshall(OutboxPollingOutboxEventAdditionalJaxbMappingProducer.createMappings("", "", "HSEARCH_OUTBOX_EVENT", 1, HibernateOrmMapperOutboxPollingSettings.Defaults.COORDINATION_ENTITY_MAPPING_OUTBOX_EVENT_UUID_GEN_STRATEGY.strategy(), false));
        OUTBOXEVENT_ENTITY_MAPPING = ConfigurationProperty.forKey((String)"outboxevent.entity.mapping").asString().build();
        ENTITY_MAPPING_OUTBOXEVENT_SCHEMA = ConfigurationProperty.forKey((String)"entity.mapping.outboxevent.schema").asString().build();
        ENTITY_MAPPING_OUTBOXEVENT_CATALOG = ConfigurationProperty.forKey((String)"entity.mapping.outboxevent.catalog").asString().build();
        ENTITY_MAPPING_OUTBOXEVENT_TABLE = ConfigurationProperty.forKey((String)"entity.mapping.outboxevent.table").asString().build();
        ENTITY_MAPPING_OUTBOXEVENT_UUID_GEN_STRATEGY = ConfigurationProperty.forKey((String)"entity.mapping.outboxevent.uuid_gen_strategy").as(UuidGenerationStrategy.class, UuidGenerationStrategy::of).build();
        ENTITY_MAPPING_OUTBOXEVENT_UUID_TYPE = ConfigurationProperty.forKey((String)"entity.mapping.outboxevent.uuid_type").asString().build();
    }
}

