/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.exception.spi;

import java.sql.SQLException;
import java.util.function.Function;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.NullnessUtil;

public class TemplatedViolatedConstraintNameExtractor
implements ViolatedConstraintNameExtractor {
    private final @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized SQLException, @UnknownKeyFor @NonNull @Initialized String> extractConstraintName;

    public TemplatedViolatedConstraintNameExtractor(@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized SQLException, @UnknownKeyFor @NonNull @Initialized String> extractConstraintName) {
        this.extractConstraintName = extractConstraintName;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized String extractConstraintName(@UnknownKeyFor @NonNull @Initialized SQLException sqle) {
        try {
            String constraintName = null;
            do {
                constraintName = this.extractConstraintName.apply(sqle);
                if (sqle.getNextException() == null || sqle.getNextException() == sqle) break;
                sqle = NullnessUtil.castNonNull(sqle.getNextException());
            } while (constraintName == null);
            return constraintName;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static @Nullable @UnknownKeyFor @Initialized String extractUsingTemplate(@UnknownKeyFor @NonNull @Initialized String templateStart, @UnknownKeyFor @NonNull @Initialized String templateEnd, @UnknownKeyFor @NonNull @Initialized String message) {
        int templateStartPosition = message.indexOf(templateStart);
        if (templateStartPosition < 0) {
            return null;
        }
        int start = templateStartPosition + templateStart.length();
        int end = message.indexOf(templateEnd, start);
        if (end < 0) {
            end = message.length();
        }
        return message.substring(start, end);
    }
}

