/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.complete;

import java.util.function.BiFunction;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.complete.CompleteResultBuilderBasicValued;
import org.hibernate.query.results.complete.ModelPartReferenceBasic;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class CompleteResultBuilderBasicModelPart
implements CompleteResultBuilderBasicValued,
ModelPartReferenceBasic {
    private final NavigablePath navigablePath;
    private final BasicValuedModelPart modelPart;
    private final String columnAlias;

    public CompleteResultBuilderBasicModelPart(NavigablePath navigablePath, BasicValuedModelPart modelPart, String columnAlias) {
        this.navigablePath = navigablePath;
        this.modelPart = modelPart;
        this.columnAlias = columnAlias;
    }

    @Override
    public Class<?> getJavaType() {
        return this.modelPart.getExpressibleJavaType().getJavaTypeClass();
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public BasicValuedModelPart getReferencedPart() {
        return this.modelPart;
    }

    @Override
    public ResultBuilder cacheKeyInstance() {
        return this;
    }

    @Override
    public BasicResult<?> buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        TableGroup tableGroup = creationStateImpl.getFromClauseAccess().getTableGroup(this.navigablePath.getParent());
        TableReference tableReference = tableGroup.resolveTableReference(this.navigablePath, this.modelPart, this.modelPart.getContainingTableExpression());
        SqlSelection sqlSelection = creationStateImpl.resolveSqlSelection(ResultsHelper.resolveSqlExpression(creationStateImpl, jdbcResultsMetadata, tableReference, this.modelPart, this.columnAlias), this.modelPart.getJdbcMapping().getJdbcJavaType(), null, creationStateImpl.getSessionFactory().getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), this.columnAlias, this.modelPart.getJdbcMapping(), this.navigablePath, false, !sqlSelection.isVirtual());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompleteResultBuilderBasicModelPart that = (CompleteResultBuilderBasicModelPart)o;
        if (!this.navigablePath.equals(that.navigablePath)) {
            return false;
        }
        if (!this.modelPart.equals(that.modelPart)) {
            return false;
        }
        return this.columnAlias.equals(that.columnAlias);
    }

    public int hashCode() {
        int result = this.navigablePath.hashCode();
        result = 31 * result + this.modelPart.hashCode();
        result = 31 * result + this.columnAlias.hashCode();
        return result;
    }
}

