/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.AssertionFailure;
import org.hibernate.query.KeyedPage;

class KeyedResult<R> {
    final R result;
    final List<Comparable<?>> key;

    public KeyedResult(R result, List<Comparable<?>> key) {
        this.result = result;
        this.key = key;
    }

    public R getResult() {
        return this.result;
    }

    public List<Comparable<?>> getKey() {
        return this.key;
    }

    static <R> List<R> collectResults(List<KeyedResult<R>> executed, int pageSize, KeyedPage.KeyInterpretation interpretation) {
        int size = executed.size();
        ArrayList<R> resultList = new ArrayList<R>(size);
        switch (interpretation) {
            case NO_KEY: 
            case KEY_OF_LAST_ON_PREVIOUS_PAGE: {
                for (int i = 0; i < size && i < pageSize; ++i) {
                    resultList.add(executed.get(i).getResult());
                }
                break;
            }
            case KEY_OF_FIRST_ON_NEXT_PAGE: {
                for (int i = pageSize - 1; i >= 0; --i) {
                    if (i >= size) continue;
                    resultList.add(executed.get(i).getResult());
                }
                break;
            }
            default: {
                throw new AssertionFailure("Unrecognized KeyInterpretation");
            }
        }
        return resultList;
    }

    static List<List<?>> collectKeys(List<? extends KeyedResult<?>> executed, int pageSize) {
        int size = executed.size();
        ArrayList resultList = new ArrayList(size);
        for (int i = 0; i < size && i < pageSize; ++i) {
            List<Comparable<?>> key = executed.get(i).getKey();
            if (key == null) {
                throw new IllegalArgumentException("Null keys in key-based pagination are not yet supported");
            }
            resultList.add(key);
        }
        return resultList;
    }
}

