/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.faulttolerance.deployment;

import io.smallrye.faulttolerance.FaultToleranceExtension;
import io.smallrye.faulttolerance.metrics.MetricsIntegration;
import jakarta.enterprise.inject.spi.Extension;
import java.util.Set;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.WeldCapability;
import org.wildfly.extension.microprofile.faulttolerance.MicroProfileFaultToleranceLogger;
import org.wildfly.extension.microprofile.faulttolerance.deployment.MicroProfileFaultToleranceMarker;

public class MicroProfileFaultToleranceDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) {
        WeldCapability weldCapability;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!MicroProfileFaultToleranceMarker.isMarked(deploymentUnit)) {
            return;
        }
        CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        try {
            weldCapability = (WeldCapability)support.getCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class);
        }
        catch (CapabilityServiceSupport.NoSuchCapabilityException e) {
            throw new IllegalStateException();
        }
        Set registeredSubsystems = (Set)deploymentUnit.getAttachment(Attachments.REGISTERED_SUBSYSTEMS);
        MetricsIntegration metricsIntegration = registeredSubsystems.contains("micrometer") ? MetricsIntegration.MICROMETER : MetricsIntegration.NOOP;
        MicroProfileFaultToleranceLogger.ROOT_LOGGER.metricsProvider(metricsIntegration.name());
        weldCapability.registerExtensionInstance((Extension)new FaultToleranceExtension(metricsIntegration), deploymentUnit);
    }
}

