/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging;

import io.smallrye.reactive.messaging.Messages;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class GenericPayload<T> {
    private final T payload;
    private final Metadata metadata;

    public static <T> GenericPayload<T> of(T payload) {
        return new GenericPayload<T>(payload, Metadata.empty());
    }

    public static <T> GenericPayload<T> of(T payload, Metadata metadata) {
        return new GenericPayload<T>(payload, metadata);
    }

    public static <T> GenericPayload<T> from(Message<T> message) {
        return new GenericPayload<T>(message.getPayload(), message.getMetadata());
    }

    public GenericPayload(T payload, Metadata metadata) {
        this.payload = payload;
        this.metadata = metadata;
    }

    public T getPayload() {
        return this.payload;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public GenericPayload<T> withMetadata(Metadata metadata) {
        return GenericPayload.of(this.payload, metadata);
    }

    public <R> GenericPayload<R> withPayload(R payload) {
        return GenericPayload.of(payload, this.metadata);
    }

    public Message<T> toMessage() {
        return Message.of(this.payload, this.metadata);
    }

    public Message<T> toMessage(Message<?> message) {
        Metadata merged = Messages.merge(message.getMetadata(), this.metadata);
        return message.withPayload(this.payload).withMetadata(merged);
    }
}

