/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal;

import io.netty.buffer.Unpooled;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;

public class RecordInfo {
    public final short compactCount;
    public final long id;
    public final byte userRecordType;
    public final byte[] data;
    public boolean isUpdate;
    public boolean replaceableUpdate;

    public RecordInfo(long id, byte userRecordType, byte[] data, boolean isUpdate, boolean replaceableUpdate, short compactCount) {
        this.id = id;
        this.userRecordType = userRecordType;
        this.data = data;
        this.isUpdate = isUpdate;
        this.replaceableUpdate = replaceableUpdate;
        this.compactCount = compactCount;
    }

    public ActiveMQBuffer wrapData() {
        return new ChannelBufferWrapper(Unpooled.wrappedBuffer((byte[])this.data), true);
    }

    public byte getUserRecordType() {
        return this.userRecordType;
    }

    public int hashCode() {
        return (int)(this.id >>> 32 ^ this.id);
    }

    public boolean equals(Object other) {
        if (!(other instanceof RecordInfo)) {
            return false;
        }
        RecordInfo r = (RecordInfo)other;
        return r.id == this.id;
    }

    public String toString() {
        return "RecordInfo (id=" + this.id + ", userRecordType = " + this.userRecordType + ", data.length = " + this.data.length + ", isUpdate = " + this.isUpdate;
    }
}

