/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.databinding;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.aegis.AegisContext;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.databinding.ElementDataReader;
import org.apache.cxf.aegis.databinding.ElementDataWriter;
import org.apache.cxf.aegis.databinding.XMLStreamDataReader;
import org.apache.cxf.aegis.databinding.XMLStreamDataWriter;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.aegis.type.TypeClassInfo;
import org.apache.cxf.aegis.type.TypeCreationOptions;
import org.apache.cxf.aegis.type.TypeCreator;
import org.apache.cxf.aegis.type.TypeMapping;
import org.apache.cxf.aegis.type.basic.ArrayType;
import org.apache.cxf.aegis.type.java5.AnnotationReader;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.common.xmlschema.XmlSchemaUtils;
import org.apache.cxf.databinding.AbstractDataBinding;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.SimpleMethodDispatcher;
import org.apache.cxf.service.invoker.MethodDispatcher;
import org.apache.cxf.service.model.AbstractMessageContainer;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.staxutils.validation.StaxSchemaValidationInInterceptor;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaException;
import org.apache.ws.commons.schema.XmlSchemaForm;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.w3c.dom.Node;

public class AegisDatabinding
extends AbstractDataBinding {
    protected static final int IN_PARAM = 0;
    protected static final int OUT_PARAM = 1;
    protected static final int FAULT_PARAM = 2;
    private static final Logger LOG = LogUtils.getL7dLogger(AegisDatabinding.class);
    private AegisContext aegisContext;
    private Map<MessagePartInfo, AegisType> part2Type = new HashMap<MessagePartInfo, AegisType>();
    private Service service;
    private boolean isInitialized;
    private Set<String> overrideTypes;
    private TypeCreationOptions configuration;
    private boolean mtomUseXmime;

    public AegisDatabinding() {
    }

    public AegisDatabinding(AegisContext ctx) {
        this();
        this.aegisContext = ctx;
    }

    private void ensureInitialized() {
        if (!this.isInitialized) {
            if (this.aegisContext == null) {
                this.aegisContext = new AegisContext();
                if (this.overrideTypes != null) {
                    this.aegisContext.setRootClassNames(this.overrideTypes);
                }
                if (this.configuration != null) {
                    this.aegisContext.setTypeCreationOptions(this.configuration);
                }
                if (this.mtomEnabled) {
                    this.aegisContext.setMtomEnabled(true);
                }
                if (this.mtomUseXmime) {
                    this.aegisContext.setMtomUseXmime(true);
                }
                this.aegisContext.initialize();
            }
            this.isInitialized = true;
        }
    }

    public <T> DataReader<T> createReader(Class<T> cls) {
        this.ensureInitialized();
        if (cls.equals(XMLStreamReader.class)) {
            return new XMLStreamDataReader(this, this.getBus());
        }
        if (cls.equals(Node.class)) {
            return new ElementDataReader(this);
        }
        throw new UnsupportedOperationException();
    }

    public <T> DataWriter<T> createWriter(Class<T> cls) {
        this.ensureInitialized();
        if (cls.equals(XMLStreamWriter.class)) {
            return new XMLStreamDataWriter(this, this.getBus());
        }
        if (cls.equals(Node.class)) {
            return new ElementDataWriter(this);
        }
        throw new UnsupportedOperationException();
    }

    public Class<?>[] getSupportedReaderFormats() {
        return new Class[]{XMLStreamReader.class, Node.class};
    }

    public Class<?>[] getSupportedWriterFormats() {
        return new Class[]{XMLStreamWriter.class, Node.class};
    }

    public void initialize(Service s) {
        if (this.aegisContext == null) {
            this.aegisContext = new AegisContext();
            Object val = s.get((Object)"mtom-enabled");
            if ("true".equals(val) || Boolean.TRUE.equals(val) || this.mtomEnabled) {
                this.setMtomEnabled(true);
                this.aegisContext.setMtomEnabled(true);
            }
            if (this.mtomUseXmime) {
                this.aegisContext.setMtomUseXmime(true);
            }
            HashMap implMap = new HashMap();
            for (Object key : s.keySet()) {
                if (!((String)key).endsWith(".implementation")) continue;
                String className = ((String)key).substring(0, ((String)key).length() - ".implementation".length());
                try {
                    String implClassName = (String)s.get(key);
                    implMap.put(ClassLoaderUtils.loadClass((String)className, ((Object)((Object)this)).getClass()), implClassName);
                }
                catch (ClassNotFoundException e) {
                    Message message = new Message("MAPPED_CLASS_NOT_FOUND", LOG, new Object[]{className, key});
                    LOG.warning(message.toString());
                }
            }
            if (this.overrideTypes != null) {
                this.aegisContext.setRootClassNames(this.overrideTypes);
            }
            if (this.configuration != null) {
                this.aegisContext.setTypeCreationOptions(this.configuration);
            }
            if (!implMap.isEmpty()) {
                this.aegisContext.setBeanImplementationMap(implMap);
            }
        }
        this.aegisContext.setMappingNamespaceURI(((ServiceInfo)s.getServiceInfos().get(0)).getInterface().getName().getNamespaceURI());
        this.aegisContext.initialize();
        this.service = s;
        s.getInInterceptors().add(new StaxSchemaValidationInInterceptor());
        HashSet<AegisType> deps = new HashSet<AegisType>();
        for (ServiceInfo info : s.getServiceInfos()) {
            for (OperationInfo opInfo : info.getInterface().getOperations()) {
                if (opInfo.isUnwrappedCapable()) {
                    this.initializeOperation(s, this.aegisContext.getTypeMapping(), opInfo.getUnwrappedOperation(), deps);
                    continue;
                }
                this.initializeOperation(s, this.aegisContext.getTypeMapping(), opInfo, deps);
            }
        }
        Set<AegisType> additional = this.aegisContext.getRootTypes();
        if (additional != null) {
            for (AegisType t : additional) {
                if (!deps.contains(t)) {
                    deps.add(t);
                }
                this.addDependencies(deps, t);
            }
        }
        this.createSchemas(s, deps);
        for (ServiceInfo info : s.getServiceInfos()) {
            for (OperationInfo opInfo : info.getInterface().getOperations()) {
                if (opInfo.isUnwrappedCapable()) {
                    this.initializeOperationTypes(info, opInfo.getUnwrappedOperation());
                    continue;
                }
                this.initializeOperationTypes(info, opInfo);
            }
        }
    }

    private void initializeOperation(Service s, TypeMapping serviceTM, OperationInfo opInfo, Set<AegisType> deps) {
        try {
            this.initializeMessage(s, serviceTM, (AbstractMessageContainer)opInfo.getInput(), 0, deps);
            if (opInfo.hasOutput()) {
                this.initializeMessage(s, serviceTM, (AbstractMessageContainer)opInfo.getOutput(), 1, deps);
            }
            for (FaultInfo info : opInfo.getFaults()) {
                this.initializeMessage(s, serviceTM, (AbstractMessageContainer)info, 2, deps);
            }
        }
        catch (DatabindingException e) {
            e.prepend("Error initializing parameters for operation " + opInfo.getName());
            throw e;
        }
    }

    private void initializeOperationTypes(ServiceInfo s, OperationInfo opInfo) {
        try {
            this.initializeMessageTypes(s, (AbstractMessageContainer)opInfo.getInput(), 0);
            if (opInfo.hasOutput()) {
                this.initializeMessageTypes(s, (AbstractMessageContainer)opInfo.getOutput(), 1);
            }
            for (FaultInfo info : opInfo.getFaults()) {
                this.initializeMessageTypes(s, (AbstractMessageContainer)info, 2);
            }
        }
        catch (DatabindingException e) {
            e.prepend("Error initializing parameters for operation " + opInfo.getName());
            throw e;
        }
    }

    protected void initializeMessage(Service s, TypeMapping serviceTM, AbstractMessageContainer container, int partType, Set<AegisType> deps) {
        if (container == null) {
            return;
        }
        for (MessagePartInfo part : container.getMessageParts()) {
            long mo;
            Integer i;
            AegisType type = this.getParameterType(s, serviceTM, part, partType);
            if (part.getXmlSchema() == null) {
                if (type.isAbstract()) {
                    part.setTypeQName(type.getSchemaType());
                } else {
                    part.setElementQName(type.getSchemaType());
                }
            }
            Annotation[] anns = (Annotation[])part.getProperty("parameter.annotations", Annotation[].class);
            long miValue = -1L;
            if (type.hasMinOccurs()) {
                miValue = type.getMinOccurs();
            }
            if ((i = AnnotationReader.getMinOccurs(anns)) != null) {
                miValue = i.intValue();
            }
            if (miValue > 0L) {
                part.setProperty("minOccurs", (Object)Long.toString(miValue));
            }
            if (part.getProperty("nillable") == null) {
                boolean isNil = type.isNillable();
                Boolean b = AnnotationReader.isNillable(anns);
                if (b != null || miValue != 0L && isNil) {
                    part.setProperty("nillable", (Object)(b == null ? isNil : b));
                }
            }
            if (type.hasMaxOccurs() && (mo = type.getMaxOccurs()) != Long.MAX_VALUE) {
                String moValue = Long.toString(mo);
                part.setProperty("maxOccurs", (Object)moValue);
            }
            this.part2Type.put(part, type);
            deps.add(type);
            type.getTypeMapping().register(type);
            this.addDependencies(deps, type);
        }
    }

    protected void initializeMessageTypes(ServiceInfo s, AbstractMessageContainer container, int partType) {
        if (container == null) {
            return;
        }
        SchemaCollection col = s.getXmlSchemaCollection();
        for (MessagePartInfo part : container.getMessageParts()) {
            XmlSchemaElement tp;
            if (part.getXmlSchema() != null) continue;
            if (part.isElement()) {
                tp = col.getElementByQName(part.getElementQName());
                part.setXmlSchema((XmlSchemaAnnotated)tp);
                continue;
            }
            tp = col.getTypeByQName(part.getTypeQName());
            part.setXmlSchema((XmlSchemaAnnotated)tp);
        }
    }

    private void addDependencies(Set<AegisType> deps, AegisType type) {
        Set<AegisType> typeDeps = type.getDependencies();
        if (typeDeps != null) {
            for (AegisType t : typeDeps) {
                if (deps.contains(t)) continue;
                deps.add(t);
                this.addDependencies(deps, t);
            }
        }
    }

    private void createSchemas(Service s, Set<AegisType> deps) {
        HashMap<String, HashSet<AegisType>> tns2Type = new HashMap<String, HashSet<AegisType>>();
        for (AegisType t : deps) {
            String ns = t.getSchemaType().getNamespaceURI();
            HashSet<AegisType> types = (HashSet<AegisType>)tns2Type.get(ns);
            if (types == null) {
                types = new HashSet<AegisType>();
                tns2Type.put(ns, types);
            }
            types.add(t);
        }
        for (ServiceInfo si : s.getServiceInfos()) {
            SchemaCollection col = si.getXmlSchemaCollection();
            if (col.getXmlSchemas().length <= 1) continue;
        }
        Map namespaceMap = this.getDeclaredNamespaceMappings();
        for (ServiceInfo si : s.getServiceInfos()) {
            SchemaInfo schemaInfo;
            XmlSchema schema;
            boolean needXmimeSchema = false;
            boolean needTypesSchema = false;
            for (Map.Entry entry : tns2Type.entrySet()) {
                String schemaNamespaceUri = (String)entry.getKey();
                if ("http://www.w3.org/2001/XMLSchema".equals(schemaNamespaceUri) || "http://cxf.apache.org/aegisTypes".equals(schemaNamespaceUri) || "http://www.w3.org/2005/05/xmlmime".equals(schemaNamespaceUri)) continue;
                SchemaInfo schemaInfo2 = si.addNewSchema((String)entry.getKey());
                XmlSchema schema2 = schemaInfo2.getSchema();
                NamespaceMap xmlsNamespaceMap = new NamespaceMap();
                if (namespaceMap != null) {
                    for (Map.Entry e : namespaceMap.entrySet()) {
                        xmlsNamespaceMap.add((String)e.getValue(), (String)e.getKey());
                    }
                }
                if (!xmlsNamespaceMap.containsKey((Object)"tns") && !xmlsNamespaceMap.containsValue(entry.getKey())) {
                    xmlsNamespaceMap.add("tns", (String)entry.getKey());
                }
                if (!xmlsNamespaceMap.containsKey((Object)"xsd") && !xmlsNamespaceMap.containsValue((Object)"http://www.w3.org/2001/XMLSchema")) {
                    xmlsNamespaceMap.add("xsd", "http://www.w3.org/2001/XMLSchema");
                }
                schema2.setNamespaceContext((NamespacePrefixList)xmlsNamespaceMap);
                schema2.setTargetNamespace((String)entry.getKey());
                schema2.setElementFormDefault(XmlSchemaForm.QUALIFIED);
                schema2.setAttributeFormDefault(XmlSchemaForm.QUALIFIED);
                for (AegisType t : (Set)entry.getValue()) {
                    try {
                        t.writeSchema(schema2);
                    }
                    catch (XmlSchemaException ex) {
                        QName name = t.getSchemaType();
                        String expected = " Schema for namespace '" + name.getNamespaceURI() + "' already contains type '" + name.getLocalPart() + "'";
                        String message = ex.getMessage();
                        if (expected.equals(message)) continue;
                        throw ex;
                    }
                }
                if (this.schemaImportsXmime(schema2)) {
                    needXmimeSchema = true;
                }
                if (!AegisContext.schemaImportsUtilityTypes(schema2)) continue;
                needTypesSchema = true;
            }
            if (needXmimeSchema) {
                schema = this.aegisContext.addXmimeSchemaDocument(si.getXmlSchemaCollection().getXmlSchemaCollection());
                schemaInfo = new SchemaInfo(schema.getTargetNamespace());
                schemaInfo.setSchema(schema);
                si.addSchema(schemaInfo);
            }
            if (needTypesSchema) {
                schema = this.aegisContext.addTypesSchemaDocument(si.getXmlSchemaCollection().getXmlSchemaCollection());
                schemaInfo = new SchemaInfo(schema.getTargetNamespace());
                schemaInfo.setSchema(schema);
                si.addSchema(schemaInfo);
            }
            si.getXmlSchemaCollection().addCrossImports();
        }
    }

    private boolean schemaImportsXmime(XmlSchema schema) {
        return XmlSchemaUtils.schemaImportsNamespace((XmlSchema)schema, (String)"http://www.w3.org/2005/05/xmlmime");
    }

    public QName getSuggestedName(Service s, TypeMapping tm, OperationInfo op, int param) {
        AegisType type;
        Method m = this.getMethod(s, op);
        if (m == null) {
            return null;
        }
        QName name = tm.getTypeCreator().getElementName(m, param);
        if (name == null && (type = tm.getTypeCreator().createType(m, param)).isComplex() && !type.isAbstract()) {
            name = type.getSchemaType();
        }
        return name;
    }

    private AegisType getParameterType(Service s, TypeMapping tm, MessagePartInfo param, int paramtype) {
        AegisType type = tm.getType(param.getTypeQName());
        if (type != null && type.getTypeClass() != param.getTypeClass()) {
            type = null;
        }
        int offset = 0;
        if (paramtype == 1) {
            offset = 1;
        }
        TypeCreator typeCreator = tm.getTypeCreator();
        if (type == null) {
            boolean usingComponentType = false;
            OperationInfo op = param.getMessageInfo().getOperation();
            Method m = this.getMethod(s, op);
            TypeClassInfo info = paramtype != 2 && m != null ? typeCreator.createClassInfo(m, param.getIndex() - offset) : typeCreator.createBasicClassInfo(param.getTypeClass());
            Boolean nillable = info.getNillable();
            type = typeCreator.createTypeForClass(info);
            if (param.getMessageInfo().getOperation().isUnwrapped() && param.getTypeClass().isArray() && type.isWriteOuter()) {
                param.setProperty("minOccurs", (Object)"1");
                param.setProperty("maxOccurs", (Object)"1");
                if (nillable == null) {
                    nillable = Boolean.TRUE;
                }
                param.setProperty("nillable", (Object)nillable);
            } else {
                if (nillable != null) {
                    param.setProperty("nillable", (Object)nillable);
                }
                if (info.getMinOccurs() != -1L) {
                    param.setProperty("minOccurs", (Object)Long.toString(info.getMinOccurs()));
                }
                if (info.getMaxOccurs() != -1L) {
                    param.setProperty("maxOccurs", (Object)Long.toString(info.getMaxOccurs()));
                }
                if (type instanceof ArrayType && !type.isWriteOuter()) {
                    param.setProperty("org.apache.cxf.aegis.outerType", (Object)type);
                    ArrayType aType = (ArrayType)type;
                    type = aType.getComponentType();
                    usingComponentType = true;
                }
            }
            if (info.getMappedName() != null) {
                param.setConcreteName(info.getMappedName());
                param.setName(info.getMappedName());
            }
            if (!usingComponentType) {
                if (info.nonDefaultAttributes()) {
                    tm.register(type);
                }
                type.setTypeMapping(tm);
            }
            this.part2Type.put(param, type);
        }
        return type;
    }

    private Method getMethod(Service s, OperationInfo op) {
        Method m = (Method)op.getProperty(Method.class.getName(), Method.class);
        if (m != null) {
            return m;
        }
        MethodDispatcher md = (MethodDispatcher)s.get((Object)MethodDispatcher.class.getName());
        if (md == null) {
            return null;
        }
        SimpleMethodDispatcher smd = (SimpleMethodDispatcher)md;
        return smd.getPrimaryMethod(op);
    }

    public AegisType getType(MessagePartInfo part) {
        return this.part2Type.get(part);
    }

    public MessagePartInfo getPartFromClass(Class<?> cls) {
        for (Map.Entry<MessagePartInfo, AegisType> entry : this.part2Type.entrySet()) {
            if (entry.getValue().getTypeClass() != cls) continue;
            return entry.getKey();
        }
        return null;
    }

    public AegisType getTypeFromClass(Class<?> cls) {
        for (AegisType t : this.part2Type.values()) {
            if (t.getTypeClass() != cls) continue;
            return t;
        }
        return null;
    }

    public Service getService() {
        return this.service;
    }

    public AegisContext getAegisContext() {
        this.ensureInitialized();
        return this.aegisContext;
    }

    public void setAegisContext(AegisContext aegisContext) {
        this.aegisContext = aegisContext;
    }

    public void setOverrideTypes(Set<String> types) {
        this.overrideTypes = types;
    }

    public void setConfiguration(TypeCreationOptions configuration) {
        this.configuration = configuration;
    }

    public boolean isMtomUseXmime() {
        return this.mtomUseXmime;
    }

    public void setMtomUseXmime(boolean mtomUseXmime) {
        this.mtomUseXmime = mtomUseXmime;
    }
}

