/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.deserializer;

import jakarta.json.bind.JsonbException;
import jakarta.json.stream.JsonParser;
import java.util.Collection;
import org.eclipse.yasson.internal.DeserializationContextImpl;
import org.eclipse.yasson.internal.deserializer.ModelDeserializer;

class CollectionDeserializer
implements ModelDeserializer<JsonParser> {
    private final ModelDeserializer<JsonParser> delegate;

    CollectionDeserializer(ModelDeserializer<JsonParser> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object deserialize(JsonParser parser, DeserializationContextImpl context) {
        Collection collection = (Collection)context.getInstance();
        block4: while (parser.hasNext()) {
            JsonParser.Event next = parser.next();
            context.setLastValueEvent(next);
            switch (next) {
                case VALUE_NULL: 
                case START_OBJECT: 
                case START_ARRAY: 
                case VALUE_STRING: 
                case VALUE_TRUE: 
                case VALUE_FALSE: 
                case VALUE_NUMBER: {
                    DeserializationContextImpl newContext = new DeserializationContextImpl(context);
                    collection.add(this.delegate.deserialize(parser, newContext));
                    continue block4;
                }
                case END_ARRAY: {
                    return collection;
                }
            }
            throw new JsonbException("Unexpected state: " + next);
        }
        return collection;
    }
}

