/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.response;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.content.ContentWriter;
import io.smallrye.openapi.runtime.io.extension.ExtensionWriter;
import io.smallrye.openapi.runtime.io.header.HeaderWriter;
import io.smallrye.openapi.runtime.io.link.LinkWriter;
import io.smallrye.openapi.runtime.util.StringUtil;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;

public class ResponseWriter {
    private ResponseWriter() {
    }

    public static void writeAPIResponses(ObjectNode parent, Map<String, APIResponse> responses) {
        if (responses == null) {
            return;
        }
        ObjectNode responsesNode = parent.putObject("responses");
        for (Map.Entry<String, APIResponse> entry : responses.entrySet()) {
            ResponseWriter.writeAPIResponse(responsesNode, entry.getValue(), entry.getKey());
        }
    }

    public static void writeAPIResponses(ObjectNode parent, APIResponses model) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject("responses");
        ExtensionWriter.writeExtensions(node, model);
        ResponseWriter.writeAPIResponse(node, model.getDefaultValue(), "default");
        if (model.getAPIResponses() != null) {
            Set entrySet = model.getAPIResponses().entrySet();
            for (Map.Entry entry : entrySet) {
                ResponseWriter.writeAPIResponse(node, (APIResponse)entry.getValue(), (String)entry.getKey());
            }
        }
    }

    private static void writeAPIResponse(ObjectNode parent, APIResponse model, String name) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(name);
        if (StringUtil.isNotEmpty(model.getRef())) {
            JsonUtil.stringProperty(node, "$ref", model.getRef());
        } else {
            JsonUtil.stringProperty(node, "description", model.getDescription());
            HeaderWriter.writeHeaders(node, model.getHeaders());
            ContentWriter.writeContent(node, model.getContent());
            LinkWriter.writeLinks(node, model.getLinks());
            ExtensionWriter.writeExtensions(node, model);
        }
    }
}

